///////////////////////////////////////////////
//
// **************************
// ** ENGLISH - 10/Jul/2017 **
//
// Project: libObfuscate v2.00
//
// This software is released under:
// * LGPL 3.0: "www.gnu.org/licenses/lgpl.html"
//
// Youre free to copy, distribute and make commercial use
// of this software under the following conditions:
// * You cite the author and copyright owner: "www.embeddedsw.net"
// * You provide a link to the Homepage: "www.embeddedsw.net/libobfuscate.html"
//
///////////////////////////////////////////////

#include "stdafx.h"

#include "Idea_nxt_common.h"
#include "Idea_nxt128_data.h"

///////////////////////////////////////////////////////////

#define NXT128_BLOCK_SIZE 16

const DWORD tbsm0_128[512] = {
    0x5d5de7bb, 0xba8dd269, 0xdede9ba4, 0x458a6fcb, 0x00000000, 0x00000000,
    0xb7b72008, 0x97d7a7af, 0xd3d38c23, 0x5fbe95b6, 0xcacaa7ab, 0x6dda65ce,
    0x3c3c4411, 0x78f01e0f, 0x0d0d1787, 0x1a34fa7d, 0xc3c3bc2f, 0x7ffe9db2,
    0xf8f8f142, 0x09127c3e, 0xcbcba429, 0x6fde99b0, 0x8d8d6ee7, 0xe33fba5d,
    0x76769ada, 0xec213be1, 0x898962e4, 0xeb2fb85c, 0xaaaa0783, 0xada355d6,
    0x121236f1, 0x244809f8, 0x88886166, 0xe92b4422, 0x222266e5, 0x448811f4,
    0x4f4fd14a, 0x9ec5db91, 0xdbdb9425, 0x4f9e91b4, 0x6d6db7af, 0xda4dca65,
    0x4747c94c, 0x8ee5df93, 0xe4e4d54b, 0x31627239, 0x4c4cd435, 0x98c92613,
    0x78788822, 0xf0193c1e, 0x9a9a5797, 0xcd634dda, 0x4949dbb4, 0x92ddd86c,
    0x93934c13, 0xdf47b5a6, 0xc4c4b553, 0x71e26231, 0xc0c0b950, 0x79f26030,
    0x8686739e, 0xf51343dd, 0x13133573, 0x264cf586, 0xa9a902fc, 0xabafa854,
    0x20206018, 0x40801008, 0x5353f543, 0xa6b5d596, 0x1c1c2409, 0x38700e07,
    0x4e4ed2c8, 0x9cc127ef, 0xcfcfa82a, 0x67ce9bb1, 0x35355f95, 0x6ad4e673,
    0x39394b90, 0x72e4e070, 0xb4b42577, 0x91db5a2d, 0xa1a11afa, 0xbb8fac56,
    0x5454fc3f, 0xa8a92a15, 0x6464ac2b, 0xc8693219, 0x0303057f, 0x060cfd82,
    0xc7c7b02c, 0x77ee9fb3, 0x858576e1, 0xf31fbe5f, 0x5c5ce439, 0xb8892e17,
    0x5b5bed45, 0xb695d194, 0xcdcdaed7, 0x63c69a4d, 0xd8d8915a, 0x49926c36,
    0x727296d9, 0xe43139e0, 0x96964392, 0xd5534bd9, 0x4242c6cd, 0x84f121ec,
    0xb8b83172, 0x89eb5c2e, 0xe1e1daca, 0x3b768c46, 0xa2a21f85, 0xbd8351d4,
    0x6060a028, 0xc0793018, 0xefefc832, 0x274e8bb9, 0xbdbd3ef3, 0x83ffa251,
    0x020206fd, 0x040801fc, 0xafaf0802, 0xa7b7aba9, 0x8c8c6d65, 0xe13b4623,
    0x7373955b, 0xe635c59e, 0x7c7c8421, 0xf8093e1f, 0x7f7f815e, 0xfe05c39d,
    0x5e5ee2c4, 0xbc812feb, 0xf9f9f2c0, 0x0b168040, 0x6565afa9, 0xca6dce67,
    0xe6e6d3b6, 0x356a73c5, 0xebebc431, 0x2f5e89b8, 0xadad0eff, 0xa3bfaa55,
    0x5a5aeec7, 0xb4912dea, 0xa5a516f9, 0xb39fae57, 0x79798ba0, 0xf21dc060,
    0x8e8e6b98, 0xe53347df, 0x15153f8d, 0x2a54f67b, 0x30305014, 0x60c0180c,
    0xececcd4d, 0x2142763b, 0xa4a4157b, 0xb19b5229, 0xc2c2bfad, 0x7dfa61cc,
    0x3e3e42ec, 0x7cf81ff3, 0xe0e0d948, 0x39727038, 0x74749c27, 0xe8293a1d,
    0x5151f3be, 0xa2bdd46a, 0xfbfbf43d, 0x0f1e81bc, 0x2d2d779f, 0x5ab4ea75,
    0x6e6eb2d0, 0xdc4137e7, 0x9494456f, 0xd15b4a25, 0x4d4dd7b7, 0x9acdda6d,
    0x5555ffbd, 0xaaadd66b, 0x34345c17, 0x68d01a0d, 0xaeae0b80, 0xa5b357d7,
    0x5252f6c1, 0xa4b129e8, 0x7e7e82dc, 0xfc013fe3, 0x9d9d5eeb, 0xc37fb259,
    0x4a4adecb, 0x94d125ee, 0xf7f7e038, 0x172e87bf, 0x80807960, 0xf90b4020,
    0xf0f0e944, 0x1932783c, 0xd0d0895c, 0x59b26834, 0x9090496c, 0xd94b4824,
    0xa7a71004, 0xb797afab, 0xe8e8c14e, 0x2952743a, 0x9f9f5816, 0xc777b3a5,
    0x5050f03c, 0xa0b92814, 0xd5d586dd, 0x53a6964b, 0xd1d18ade, 0x5bb6944a,
    0x9898516a, 0xc96b4c26, 0xccccad55, 0x61c26633, 0xa0a01978, 0xb98b5028,
    0x17173970, 0x2e5cf787, 0xf4f4e547, 0x11227a3d, 0xb6b6238a, 0x95d35bd1,
    0xc1c1bad2, 0x7bf69c4e, 0x2828781e, 0x50a0140a, 0x5f5fe146, 0xbe85d395,
    0x26266ae6, 0x4c9813f5, 0x01010382, 0x0204fc7e, 0xabab0401, 0xafa7a9a8,
    0x25256f99, 0x4a94ee77, 0x38384812, 0x70e01c0e, 0x82827f9d, 0xfd0341dc,
    0x7d7d87a3, 0xfa0dc261, 0x4848d836, 0x90d92412, 0xfcfcfd41, 0x01027e3f,
    0x1b1b2d75, 0x366cf184, 0xceceaba8, 0x65ca67cf, 0x3f3f416e, 0x7efce38d,
    0x6b6bbd51, 0xd655c998, 0xe2e2dfb5, 0x3d7a71c4, 0x6767a954, 0xce65cf9b,
    0x6666aad6, 0xcc6133e5, 0x4343c54f, 0x86f5dd92, 0x5959ebb8, 0xb29dd068,
    0x19192b88, 0x3264f078, 0x84847563, 0xf11b4221, 0x3d3d4793, 0x7af4e271,
    0xf5f5e6c5, 0x13268643, 0x2f2f7162, 0x5ebceb89, 0xc9c9a2d4, 0x6bd6984c,
    0xbcbc3d71, 0x81fb5e2f, 0xd9d992d8, 0x4b969048, 0x959546ed, 0xd35fb65b,
    0x29297b9c, 0x52a4e874, 0x4141c3b2, 0x82fddc6e, 0xdada97a7, 0x4d9a6dca,
    0x1a1a2ef7, 0x34680dfa, 0xb0b02974, 0x99cb582c, 0xe9e9c2cc, 0x2b568844,
    0x6969bbac, 0xd25dc864, 0xd2d28fa1, 0x5dba69c8, 0x7b7b8d5d, 0xf615c19c,
    0xd7d78020, 0x57ae97b7, 0x1111338e, 0x2244f47a, 0x9b9b5415, 0xcf67b1a4,
    0x3333556b, 0x66cce58e, 0x8a8a679b, 0xed2345de, 0x23236567, 0x468ced8a,
    0x09091b84, 0x1224f87c, 0xd4d4855f, 0x51a26a35, 0x717193a6, 0xe23dc462,
    0x4444cc33, 0x88e92211, 0x6868b82e, 0xd059341a, 0x6f6fb152, 0xde45cb99,
    0xf2f2efb9, 0x1d3a79c0, 0x0e0e12f8, 0x1c3807ff, 0xdfdf9826, 0x478e93b5,
    0x8787701c, 0xf717bfa3, 0xdcdc9d59, 0x41826e37, 0x83837c1f, 0xff07bda2,
    0x1818280a, 0x30600c06, 0x6a6abed3, 0xd45135e6, 0xeeeecbb0, 0x254a77c7,
    0x999952e8, 0xcb6fb058, 0x81817ae2, 0xfb0fbc5e, 0x6262a6d5, 0xc47131e4,
    0x36365aea, 0x6cd81bf1, 0x2e2e72e0, 0x5cb817f7, 0x7a7a8edf, 0xf4113de2,
    0xfefefbbc, 0x050a7fc3, 0x4545cfb1, 0x8aedde6f, 0x9c9c5d69, 0xc17b4e27,
    0x75759fa5, 0xea2dc663, 0x91914aee, 0xdb4fb45a, 0x0c0c1405, 0x18300603,
    0x0f0f117a, 0x1e3cfb81, 0xe7e7d034, 0x376e8fbb, 0xf6f6e3ba, 0x152a7bc1,
    0x14143c0f, 0x28500a05, 0x6363a557, 0xc675cd9a, 0x1d1d278b, 0x3a74f279,
    0x0b0b1d79, 0x162cf980, 0x8b8b6419, 0xef27b9a0, 0xb3b32c0b, 0x9fc7a5ae,
    0xf3f3ec3b, 0x1f3e85be, 0xb2b22f89, 0x9dc359d0, 0x3b3b4d6d, 0x76ece18c,
    0x08081806, 0x10200402, 0x4b4bdd49, 0x96d5d990, 0x1010300c, 0x20400804,
    0xa6a61386, 0xb59353d5, 0x323256e9, 0x64c819f0, 0xb9b932f0, 0x8befa050,
    0xa8a8017e, 0xa9ab542a, 0x92924f91, 0xdd4349d8, 0xf1f1eac6, 0x1b368442,
    0x5656fac2, 0xaca12be9, 0xdddd9edb, 0x43869249, 0x2121639a, 0x4284ec76,
    0xbfbf380e, 0x87f7a3ad, 0x04040c03, 0x08100201, 0xbebe3b8c, 0x85f35fd3,
    0xd6d683a2, 0x55aa6bc9, 0xfdfdfec3, 0x03068241, 0x77779958, 0xee25c79f,
    0xeaeac7b3, 0x2d5a75c6, 0x3a3a4eef, 0x74e81df2, 0xc8c8a156, 0x69d26432,
    0x8f8f681a, 0xe737bba1, 0x5757f940, 0xaea5d797, 0x1e1e22f4, 0x3c780ffb,
    0xfafaf7bf, 0x0d1a7dc2, 0x2b2b7d61, 0x56ace988, 0x5858e83a, 0xb0992c16,
    0xc5c5b6d1, 0x73e69e4f, 0x27276964, 0x4e9cef8b, 0xacac0d7d, 0xa1bb562b,
    0xe3e3dc37, 0x3f7e8dba, 0xededcecf, 0x23468a45, 0x97974010, 0xd757b7a7,
    0xbbbb340d, 0x8fe7a1ac, 0x4646cace, 0x8ce123ed, 0x05050f81, 0x0a14fe7f,
    0x4040c030, 0x80f92010, 0x31315396, 0x62c4e472, 0xe5e5d6c9, 0x33668e47,
    0x37375968, 0x6edce78f, 0x2c2c741d, 0x58b0160b, 0x9e9e5b94, 0xc5734fdb,
    0x0a0a1efb, 0x142805fe, 0xb1b12af6, 0x9bcfa452, 0xb5b526f5, 0x93dfa653,
    0x06060afe, 0x0c1803fd, 0x6c6cb42d, 0xd849361b, 0x1f1f2176, 0x3e7cf385,
    0xa3a31c07, 0xbf87adaa, 0x2a2a7ee3, 0x54a815f6, 0x70709024, 0xe039381c,
    0xfffff83e, 0x070e83bd, 0xbaba378f, 0x8de35dd2, 0x0707097c, 0x0e1cff83,
    0x24246c1b, 0x48901209, 0x16163af2, 0x2c580bf9, 0xc6c6b3ae, 0x75ea63cd,
    0x6161a3aa, 0xc27dcc66};

const DWORD tbsm1_128[512] = {
    0x5de7bbba, 0x8dd2695d, 0xde9ba445, 0x8a6fcbde, 0x00000000, 0x00000000,
    0xb7200897, 0xd7a7afb7, 0xd38c235f, 0xbe95b6d3, 0xcaa7ab6d, 0xda65ceca,
    0x3c441178, 0xf01e0f3c, 0x0d17871a, 0x34fa7d0d, 0xc3bc2f7f, 0xfe9db2c3,
    0xf8f14209, 0x127c3ef8, 0xcba4296f, 0xde99b0cb, 0x8d6ee7e3, 0x3fba5d8d,
    0x769adaec, 0x213be176, 0x8962e4eb, 0x2fb85c89, 0xaa0783ad, 0xa355d6aa,
    0x1236f124, 0x4809f812, 0x886166e9, 0x2b442288, 0x2266e544, 0x8811f422,
    0x4fd14a9e, 0xc5db914f, 0xdb94254f, 0x9e91b4db, 0x6db7afda, 0x4dca656d,
    0x47c94c8e, 0xe5df9347, 0xe4d54b31, 0x627239e4, 0x4cd43598, 0xc926134c,
    0x788822f0, 0x193c1e78, 0x9a5797cd, 0x634dda9a, 0x49dbb492, 0xddd86c49,
    0x934c13df, 0x47b5a693, 0xc4b55371, 0xe26231c4, 0xc0b95079, 0xf26030c0,
    0x86739ef5, 0x1343dd86, 0x13357326, 0x4cf58613, 0xa902fcab, 0xafa854a9,
    0x20601840, 0x80100820, 0x53f543a6, 0xb5d59653, 0x1c240938, 0x700e071c,
    0x4ed2c89c, 0xc127ef4e, 0xcfa82a67, 0xce9bb1cf, 0x355f956a, 0xd4e67335,
    0x394b9072, 0xe4e07039, 0xb4257791, 0xdb5a2db4, 0xa11afabb, 0x8fac56a1,
    0x54fc3fa8, 0xa92a1554, 0x64ac2bc8, 0x69321964, 0x03057f06, 0x0cfd8203,
    0xc7b02c77, 0xee9fb3c7, 0x8576e1f3, 0x1fbe5f85, 0x5ce439b8, 0x892e175c,
    0x5bed45b6, 0x95d1945b, 0xcdaed763, 0xc69a4dcd, 0xd8915a49, 0x926c36d8,
    0x7296d9e4, 0x3139e072, 0x964392d5, 0x534bd996, 0x42c6cd84, 0xf121ec42,
    0xb8317289, 0xeb5c2eb8, 0xe1daca3b, 0x768c46e1, 0xa21f85bd, 0x8351d4a2,
    0x60a028c0, 0x79301860, 0xefc83227, 0x4e8bb9ef, 0xbd3ef383, 0xffa251bd,
    0x0206fd04, 0x0801fc02, 0xaf0802a7, 0xb7aba9af, 0x8c6d65e1, 0x3b46238c,
    0x73955be6, 0x35c59e73, 0x7c8421f8, 0x093e1f7c, 0x7f815efe, 0x05c39d7f,
    0x5ee2c4bc, 0x812feb5e, 0xf9f2c00b, 0x168040f9, 0x65afa9ca, 0x6dce6765,
    0xe6d3b635, 0x6a73c5e6, 0xebc4312f, 0x5e89b8eb, 0xad0effa3, 0xbfaa55ad,
    0x5aeec7b4, 0x912dea5a, 0xa516f9b3, 0x9fae57a5, 0x798ba0f2, 0x1dc06079,
    0x8e6b98e5, 0x3347df8e, 0x153f8d2a, 0x54f67b15, 0x30501460, 0xc0180c30,
    0xeccd4d21, 0x42763bec, 0xa4157bb1, 0x9b5229a4, 0xc2bfad7d, 0xfa61ccc2,
    0x3e42ec7c, 0xf81ff33e, 0xe0d94839, 0x727038e0, 0x749c27e8, 0x293a1d74,
    0x51f3bea2, 0xbdd46a51, 0xfbf43d0f, 0x1e81bcfb, 0x2d779f5a, 0xb4ea752d,
    0x6eb2d0dc, 0x4137e76e, 0x94456fd1, 0x5b4a2594, 0x4dd7b79a, 0xcdda6d4d,
    0x55ffbdaa, 0xadd66b55, 0x345c1768, 0xd01a0d34, 0xae0b80a5, 0xb357d7ae,
    0x52f6c1a4, 0xb129e852, 0x7e82dcfc, 0x013fe37e, 0x9d5eebc3, 0x7fb2599d,
    0x4adecb94, 0xd125ee4a, 0xf7e03817, 0x2e87bff7, 0x807960f9, 0x0b402080,
    0xf0e94419, 0x32783cf0, 0xd0895c59, 0xb26834d0, 0x90496cd9, 0x4b482490,
    0xa71004b7, 0x97afaba7, 0xe8c14e29, 0x52743ae8, 0x9f5816c7, 0x77b3a59f,
    0x50f03ca0, 0xb9281450, 0xd586dd53, 0xa6964bd5, 0xd18ade5b, 0xb6944ad1,
    0x98516ac9, 0x6b4c2698, 0xccad5561, 0xc26633cc, 0xa01978b9, 0x8b5028a0,
    0x1739702e, 0x5cf78717, 0xf4e54711, 0x227a3df4, 0xb6238a95, 0xd35bd1b6,
    0xc1bad27b, 0xf69c4ec1, 0x28781e50, 0xa0140a28, 0x5fe146be, 0x85d3955f,
    0x266ae64c, 0x9813f526, 0x01038202, 0x04fc7e01, 0xab0401af, 0xa7a9a8ab,
    0x256f994a, 0x94ee7725, 0x38481270, 0xe01c0e38, 0x827f9dfd, 0x0341dc82,
    0x7d87a3fa, 0x0dc2617d, 0x48d83690, 0xd9241248, 0xfcfd4101, 0x027e3ffc,
    0x1b2d7536, 0x6cf1841b, 0xceaba865, 0xca67cfce, 0x3f416e7e, 0xfce38d3f,
    0x6bbd51d6, 0x55c9986b, 0xe2dfb53d, 0x7a71c4e2, 0x67a954ce, 0x65cf9b67,
    0x66aad6cc, 0x6133e566, 0x43c54f86, 0xf5dd9243, 0x59ebb8b2, 0x9dd06859,
    0x192b8832, 0x64f07819, 0x847563f1, 0x1b422184, 0x3d47937a, 0xf4e2713d,
    0xf5e6c513, 0x268643f5, 0x2f71625e, 0xbceb892f, 0xc9a2d46b, 0xd6984cc9,
    0xbc3d7181, 0xfb5e2fbc, 0xd992d84b, 0x969048d9, 0x9546edd3, 0x5fb65b95,
    0x297b9c52, 0xa4e87429, 0x41c3b282, 0xfddc6e41, 0xda97a74d, 0x9a6dcada,
    0x1a2ef734, 0x680dfa1a, 0xb0297499, 0xcb582cb0, 0xe9c2cc2b, 0x568844e9,
    0x69bbacd2, 0x5dc86469, 0xd28fa15d, 0xba69c8d2, 0x7b8d5df6, 0x15c19c7b,
    0xd7802057, 0xae97b7d7, 0x11338e22, 0x44f47a11, 0x9b5415cf, 0x67b1a49b,
    0x33556b66, 0xcce58e33, 0x8a679bed, 0x2345de8a, 0x23656746, 0x8ced8a23,
    0x091b8412, 0x24f87c09, 0xd4855f51, 0xa26a35d4, 0x7193a6e2, 0x3dc46271,
    0x44cc3388, 0xe9221144, 0x68b82ed0, 0x59341a68, 0x6fb152de, 0x45cb996f,
    0xf2efb91d, 0x3a79c0f2, 0x0e12f81c, 0x3807ff0e, 0xdf982647, 0x8e93b5df,
    0x87701cf7, 0x17bfa387, 0xdc9d5941, 0x826e37dc, 0x837c1fff, 0x07bda283,
    0x18280a30, 0x600c0618, 0x6abed3d4, 0x5135e66a, 0xeecbb025, 0x4a77c7ee,
    0x9952e8cb, 0x6fb05899, 0x817ae2fb, 0x0fbc5e81, 0x62a6d5c4, 0x7131e462,
    0x365aea6c, 0xd81bf136, 0x2e72e05c, 0xb817f72e, 0x7a8edff4, 0x113de27a,
    0xfefbbc05, 0x0a7fc3fe, 0x45cfb18a, 0xedde6f45, 0x9c5d69c1, 0x7b4e279c,
    0x759fa5ea, 0x2dc66375, 0x914aeedb, 0x4fb45a91, 0x0c140518, 0x3006030c,
    0x0f117a1e, 0x3cfb810f, 0xe7d03437, 0x6e8fbbe7, 0xf6e3ba15, 0x2a7bc1f6,
    0x143c0f28, 0x500a0514, 0x63a557c6, 0x75cd9a63, 0x1d278b3a, 0x74f2791d,
    0x0b1d7916, 0x2cf9800b, 0x8b6419ef, 0x27b9a08b, 0xb32c0b9f, 0xc7a5aeb3,
    0xf3ec3b1f, 0x3e85bef3, 0xb22f899d, 0xc359d0b2, 0x3b4d6d76, 0xece18c3b,
    0x08180610, 0x20040208, 0x4bdd4996, 0xd5d9904b, 0x10300c20, 0x40080410,
    0xa61386b5, 0x9353d5a6, 0x3256e964, 0xc819f032, 0xb932f08b, 0xefa050b9,
    0xa8017ea9, 0xab542aa8, 0x924f91dd, 0x4349d892, 0xf1eac61b, 0x368442f1,
    0x56fac2ac, 0xa12be956, 0xdd9edb43, 0x869249dd, 0x21639a42, 0x84ec7621,
    0xbf380e87, 0xf7a3adbf, 0x040c0308, 0x10020104, 0xbe3b8c85, 0xf35fd3be,
    0xd683a255, 0xaa6bc9d6, 0xfdfec303, 0x068241fd, 0x779958ee, 0x25c79f77,
    0xeac7b32d, 0x5a75c6ea, 0x3a4eef74, 0xe81df23a, 0xc8a15669, 0xd26432c8,
    0x8f681ae7, 0x37bba18f, 0x57f940ae, 0xa5d79757, 0x1e22f43c, 0x780ffb1e,
    0xfaf7bf0d, 0x1a7dc2fa, 0x2b7d6156, 0xace9882b, 0x58e83ab0, 0x992c1658,
    0xc5b6d173, 0xe69e4fc5, 0x2769644e, 0x9cef8b27, 0xac0d7da1, 0xbb562bac,
    0xe3dc373f, 0x7e8dbae3, 0xedcecf23, 0x468a45ed, 0x974010d7, 0x57b7a797,
    0xbb340d8f, 0xe7a1acbb, 0x46cace8c, 0xe123ed46, 0x050f810a, 0x14fe7f05,
    0x40c03080, 0xf9201040, 0x31539662, 0xc4e47231, 0xe5d6c933, 0x668e47e5,
    0x3759686e, 0xdce78f37, 0x2c741d58, 0xb0160b2c, 0x9e5b94c5, 0x734fdb9e,
    0x0a1efb14, 0x2805fe0a, 0xb12af69b, 0xcfa452b1, 0xb526f593, 0xdfa653b5,
    0x060afe0c, 0x1803fd06, 0x6cb42dd8, 0x49361b6c, 0x1f21763e, 0x7cf3851f,
    0xa31c07bf, 0x87adaaa3, 0x2a7ee354, 0xa815f62a, 0x709024e0, 0x39381c70,
    0xfff83e07, 0x0e83bdff, 0xba378f8d, 0xe35dd2ba, 0x07097c0e, 0x1cff8307,
    0x246c1b48, 0x90120924, 0x163af22c, 0x580bf916, 0xc6b3ae75, 0xea63cdc6,
    0x61a3aac2, 0x7dcc6661};

const DWORD tbsm2_128[512] = {
    0x5dbbba8d, 0xd2695de7, 0xdea4458a, 0x6fcbde9b, 0x00000000, 0x00000000,
    0xb70897d7, 0xa7afb720, 0xd3235fbe, 0x95b6d38c, 0xcaab6dda, 0x65cecaa7,
    0x3c1178f0, 0x1e0f3c44, 0x0d871a34, 0xfa7d0d17, 0xc32f7ffe, 0x9db2c3bc,
    0xf8420912, 0x7c3ef8f1, 0xcb296fde, 0x99b0cba4, 0x8de7e33f, 0xba5d8d6e,
    0x76daec21, 0x3be1769a, 0x89e4eb2f, 0xb85c8962, 0xaa83ada3, 0x55d6aa07,
    0x12f12448, 0x09f81236, 0x8866e92b, 0x44228861, 0x22e54488, 0x11f42266,
    0x4f4a9ec5, 0xdb914fd1, 0xdb254f9e, 0x91b4db94, 0x6dafda4d, 0xca656db7,
    0x474c8ee5, 0xdf9347c9, 0xe44b3162, 0x7239e4d5, 0x4c3598c9, 0x26134cd4,
    0x7822f019, 0x3c1e7888, 0x9a97cd63, 0x4dda9a57, 0x49b492dd, 0xd86c49db,
    0x9313df47, 0xb5a6934c, 0xc45371e2, 0x6231c4b5, 0xc05079f2, 0x6030c0b9,
    0x869ef513, 0x43dd8673, 0x1373264c, 0xf5861335, 0xa9fcabaf, 0xa854a902,
    0x20184080, 0x10082060, 0x5343a6b5, 0xd59653f5, 0x1c093870, 0x0e071c24,
    0x4ec89cc1, 0x27ef4ed2, 0xcf2a67ce, 0x9bb1cfa8, 0x35956ad4, 0xe673355f,
    0x399072e4, 0xe070394b, 0xb47791db, 0x5a2db425, 0xa1fabb8f, 0xac56a11a,
    0x543fa8a9, 0x2a1554fc, 0x642bc869, 0x321964ac, 0x037f060c, 0xfd820305,
    0xc72c77ee, 0x9fb3c7b0, 0x85e1f31f, 0xbe5f8576, 0x5c39b889, 0x2e175ce4,
    0x5b45b695, 0xd1945bed, 0xcdd763c6, 0x9a4dcdae, 0xd85a4992, 0x6c36d891,
    0x72d9e431, 0x39e07296, 0x9692d553, 0x4bd99643, 0x42cd84f1, 0x21ec42c6,
    0xb87289eb, 0x5c2eb831, 0xe1ca3b76, 0x8c46e1da, 0xa285bd83, 0x51d4a21f,
    0x6028c079, 0x301860a0, 0xef32274e, 0x8bb9efc8, 0xbdf383ff, 0xa251bd3e,
    0x02fd0408, 0x01fc0206, 0xaf02a7b7, 0xaba9af08, 0x8c65e13b, 0x46238c6d,
    0x735be635, 0xc59e7395, 0x7c21f809, 0x3e1f7c84, 0x7f5efe05, 0xc39d7f81,
    0x5ec4bc81, 0x2feb5ee2, 0xf9c00b16, 0x8040f9f2, 0x65a9ca6d, 0xce6765af,
    0xe6b6356a, 0x73c5e6d3, 0xeb312f5e, 0x89b8ebc4, 0xadffa3bf, 0xaa55ad0e,
    0x5ac7b491, 0x2dea5aee, 0xa5f9b39f, 0xae57a516, 0x79a0f21d, 0xc060798b,
    0x8e98e533, 0x47df8e6b, 0x158d2a54, 0xf67b153f, 0x301460c0, 0x180c3050,
    0xec4d2142, 0x763beccd, 0xa47bb19b, 0x5229a415, 0xc2ad7dfa, 0x61ccc2bf,
    0x3eec7cf8, 0x1ff33e42, 0xe0483972, 0x7038e0d9, 0x7427e829, 0x3a1d749c,
    0x51bea2bd, 0xd46a51f3, 0xfb3d0f1e, 0x81bcfbf4, 0x2d9f5ab4, 0xea752d77,
    0x6ed0dc41, 0x37e76eb2, 0x946fd15b, 0x4a259445, 0x4db79acd, 0xda6d4dd7,
    0x55bdaaad, 0xd66b55ff, 0x341768d0, 0x1a0d345c, 0xae80a5b3, 0x57d7ae0b,
    0x52c1a4b1, 0x29e852f6, 0x7edcfc01, 0x3fe37e82, 0x9debc37f, 0xb2599d5e,
    0x4acb94d1, 0x25ee4ade, 0xf738172e, 0x87bff7e0, 0x8060f90b, 0x40208079,
    0xf0441932, 0x783cf0e9, 0xd05c59b2, 0x6834d089, 0x906cd94b, 0x48249049,
    0xa704b797, 0xafaba710, 0xe84e2952, 0x743ae8c1, 0x9f16c777, 0xb3a59f58,
    0x503ca0b9, 0x281450f0, 0xd5dd53a6, 0x964bd586, 0xd1de5bb6, 0x944ad18a,
    0x986ac96b, 0x4c269851, 0xcc5561c2, 0x6633ccad, 0xa078b98b, 0x5028a019,
    0x17702e5c, 0xf7871739, 0xf4471122, 0x7a3df4e5, 0xb68a95d3, 0x5bd1b623,
    0xc1d27bf6, 0x9c4ec1ba, 0x281e50a0, 0x140a2878, 0x5f46be85, 0xd3955fe1,
    0x26e64c98, 0x13f5266a, 0x01820204, 0xfc7e0103, 0xab01afa7, 0xa9a8ab04,
    0x25994a94, 0xee77256f, 0x381270e0, 0x1c0e3848, 0x829dfd03, 0x41dc827f,
    0x7da3fa0d, 0xc2617d87, 0x483690d9, 0x241248d8, 0xfc410102, 0x7e3ffcfd,
    0x1b75366c, 0xf1841b2d, 0xcea865ca, 0x67cfceab, 0x3f6e7efc, 0xe38d3f41,
    0x6b51d655, 0xc9986bbd, 0xe2b53d7a, 0x71c4e2df, 0x6754ce65, 0xcf9b67a9,
    0x66d6cc61, 0x33e566aa, 0x434f86f5, 0xdd9243c5, 0x59b8b29d, 0xd06859eb,
    0x19883264, 0xf078192b, 0x8463f11b, 0x42218475, 0x3d937af4, 0xe2713d47,
    0xf5c51326, 0x8643f5e6, 0x2f625ebc, 0xeb892f71, 0xc9d46bd6, 0x984cc9a2,
    0xbc7181fb, 0x5e2fbc3d, 0xd9d84b96, 0x9048d992, 0x95edd35f, 0xb65b9546,
    0x299c52a4, 0xe874297b, 0x41b282fd, 0xdc6e41c3, 0xdaa74d9a, 0x6dcada97,
    0x1af73468, 0x0dfa1a2e, 0xb07499cb, 0x582cb029, 0xe9cc2b56, 0x8844e9c2,
    0x69acd25d, 0xc86469bb, 0xd2a15dba, 0x69c8d28f, 0x7b5df615, 0xc19c7b8d,
    0xd72057ae, 0x97b7d780, 0x118e2244, 0xf47a1133, 0x9b15cf67, 0xb1a49b54,
    0x336b66cc, 0xe58e3355, 0x8a9bed23, 0x45de8a67, 0x2367468c, 0xed8a2365,
    0x09841224, 0xf87c091b, 0xd45f51a2, 0x6a35d485, 0x71a6e23d, 0xc4627193,
    0x443388e9, 0x221144cc, 0x682ed059, 0x341a68b8, 0x6f52de45, 0xcb996fb1,
    0xf2b91d3a, 0x79c0f2ef, 0x0ef81c38, 0x07ff0e12, 0xdf26478e, 0x93b5df98,
    0x871cf717, 0xbfa38770, 0xdc594182, 0x6e37dc9d, 0x831fff07, 0xbda2837c,
    0x180a3060, 0x0c061828, 0x6ad3d451, 0x35e66abe, 0xeeb0254a, 0x77c7eecb,
    0x99e8cb6f, 0xb0589952, 0x81e2fb0f, 0xbc5e817a, 0x62d5c471, 0x31e462a6,
    0x36ea6cd8, 0x1bf1365a, 0x2ee05cb8, 0x17f72e72, 0x7adff411, 0x3de27a8e,
    0xfebc050a, 0x7fc3fefb, 0x45b18aed, 0xde6f45cf, 0x9c69c17b, 0x4e279c5d,
    0x75a5ea2d, 0xc663759f, 0x91eedb4f, 0xb45a914a, 0x0c051830, 0x06030c14,
    0x0f7a1e3c, 0xfb810f11, 0xe734376e, 0x8fbbe7d0, 0xf6ba152a, 0x7bc1f6e3,
    0x140f2850, 0x0a05143c, 0x6357c675, 0xcd9a63a5, 0x1d8b3a74, 0xf2791d27,
    0x0b79162c, 0xf9800b1d, 0x8b19ef27, 0xb9a08b64, 0xb30b9fc7, 0xa5aeb32c,
    0xf33b1f3e, 0x85bef3ec, 0xb2899dc3, 0x59d0b22f, 0x3b6d76ec, 0xe18c3b4d,
    0x08061020, 0x04020818, 0x4b4996d5, 0xd9904bdd, 0x100c2040, 0x08041030,
    0xa686b593, 0x53d5a613, 0x32e964c8, 0x19f03256, 0xb9f08bef, 0xa050b932,
    0xa87ea9ab, 0x542aa801, 0x9291dd43, 0x49d8924f, 0xf1c61b36, 0x8442f1ea,
    0x56c2aca1, 0x2be956fa, 0xdddb4386, 0x9249dd9e, 0x219a4284, 0xec762163,
    0xbf0e87f7, 0xa3adbf38, 0x04030810, 0x0201040c, 0xbe8c85f3, 0x5fd3be3b,
    0xd6a255aa, 0x6bc9d683, 0xfdc30306, 0x8241fdfe, 0x7758ee25, 0xc79f7799,
    0xeab32d5a, 0x75c6eac7, 0x3aef74e8, 0x1df23a4e, 0xc85669d2, 0x6432c8a1,
    0x8f1ae737, 0xbba18f68, 0x5740aea5, 0xd79757f9, 0x1ef43c78, 0x0ffb1e22,
    0xfabf0d1a, 0x7dc2faf7, 0x2b6156ac, 0xe9882b7d, 0x583ab099, 0x2c1658e8,
    0xc5d173e6, 0x9e4fc5b6, 0x27644e9c, 0xef8b2769, 0xac7da1bb, 0x562bac0d,
    0xe3373f7e, 0x8dbae3dc, 0xedcf2346, 0x8a45edce, 0x9710d757, 0xb7a79740,
    0xbb0d8fe7, 0xa1acbb34, 0x46ce8ce1, 0x23ed46ca, 0x05810a14, 0xfe7f050f,
    0x403080f9, 0x201040c0, 0x319662c4, 0xe4723153, 0xe5c93366, 0x8e47e5d6,
    0x37686edc, 0xe78f3759, 0x2c1d58b0, 0x160b2c74, 0x9e94c573, 0x4fdb9e5b,
    0x0afb1428, 0x05fe0a1e, 0xb1f69bcf, 0xa452b12a, 0xb5f593df, 0xa653b526,
    0x06fe0c18, 0x03fd060a, 0x6c2dd849, 0x361b6cb4, 0x1f763e7c, 0xf3851f21,
    0xa307bf87, 0xadaaa31c, 0x2ae354a8, 0x15f62a7e, 0x7024e039, 0x381c7090,
    0xff3e070e, 0x83bdfff8, 0xba8f8de3, 0x5dd2ba37, 0x077c0e1c, 0xff830709,
    0x241b4890, 0x1209246c, 0x16f22c58, 0x0bf9163a, 0xc6ae75ea, 0x63cdc6b3,
    0x61aac27d, 0xcc6661a3};

const DWORD tbsm3_128[512] = {
    0x5dba8dd2, 0x695de7bb, 0xde458a6f, 0xcbde9ba4, 0x00000000, 0x00000000,
    0xb797d7a7, 0xafb72008, 0xd35fbe95, 0xb6d38c23, 0xca6dda65, 0xcecaa7ab,
    0x3c78f01e, 0x0f3c4411, 0x0d1a34fa, 0x7d0d1787, 0xc37ffe9d, 0xb2c3bc2f,
    0xf809127c, 0x3ef8f142, 0xcb6fde99, 0xb0cba429, 0x8de33fba, 0x5d8d6ee7,
    0x76ec213b, 0xe1769ada, 0x89eb2fb8, 0x5c8962e4, 0xaaada355, 0xd6aa0783,
    0x12244809, 0xf81236f1, 0x88e92b44, 0x22886166, 0x22448811, 0xf42266e5,
    0x4f9ec5db, 0x914fd14a, 0xdb4f9e91, 0xb4db9425, 0x6dda4dca, 0x656db7af,
    0x478ee5df, 0x9347c94c, 0xe4316272, 0x39e4d54b, 0x4c98c926, 0x134cd435,
    0x78f0193c, 0x1e788822, 0x9acd634d, 0xda9a5797, 0x4992ddd8, 0x6c49dbb4,
    0x93df47b5, 0xa6934c13, 0xc471e262, 0x31c4b553, 0xc079f260, 0x30c0b950,
    0x86f51343, 0xdd86739e, 0x13264cf5, 0x86133573, 0xa9abafa8, 0x54a902fc,
    0x20408010, 0x08206018, 0x53a6b5d5, 0x9653f543, 0x1c38700e, 0x071c2409,
    0x4e9cc127, 0xef4ed2c8, 0xcf67ce9b, 0xb1cfa82a, 0x356ad4e6, 0x73355f95,
    0x3972e4e0, 0x70394b90, 0xb491db5a, 0x2db42577, 0xa1bb8fac, 0x56a11afa,
    0x54a8a92a, 0x1554fc3f, 0x64c86932, 0x1964ac2b, 0x03060cfd, 0x8203057f,
    0xc777ee9f, 0xb3c7b02c, 0x85f31fbe, 0x5f8576e1, 0x5cb8892e, 0x175ce439,
    0x5bb695d1, 0x945bed45, 0xcd63c69a, 0x4dcdaed7, 0xd849926c, 0x36d8915a,
    0x72e43139, 0xe07296d9, 0x96d5534b, 0xd9964392, 0x4284f121, 0xec42c6cd,
    0xb889eb5c, 0x2eb83172, 0xe13b768c, 0x46e1daca, 0xa2bd8351, 0xd4a21f85,
    0x60c07930, 0x1860a028, 0xef274e8b, 0xb9efc832, 0xbd83ffa2, 0x51bd3ef3,
    0x02040801, 0xfc0206fd, 0xafa7b7ab, 0xa9af0802, 0x8ce13b46, 0x238c6d65,
    0x73e635c5, 0x9e73955b, 0x7cf8093e, 0x1f7c8421, 0x7ffe05c3, 0x9d7f815e,
    0x5ebc812f, 0xeb5ee2c4, 0xf90b1680, 0x40f9f2c0, 0x65ca6dce, 0x6765afa9,
    0xe6356a73, 0xc5e6d3b6, 0xeb2f5e89, 0xb8ebc431, 0xada3bfaa, 0x55ad0eff,
    0x5ab4912d, 0xea5aeec7, 0xa5b39fae, 0x57a516f9, 0x79f21dc0, 0x60798ba0,
    0x8ee53347, 0xdf8e6b98, 0x152a54f6, 0x7b153f8d, 0x3060c018, 0x0c305014,
    0xec214276, 0x3beccd4d, 0xa4b19b52, 0x29a4157b, 0xc27dfa61, 0xccc2bfad,
    0x3e7cf81f, 0xf33e42ec, 0xe0397270, 0x38e0d948, 0x74e8293a, 0x1d749c27,
    0x51a2bdd4, 0x6a51f3be, 0xfb0f1e81, 0xbcfbf43d, 0x2d5ab4ea, 0x752d779f,
    0x6edc4137, 0xe76eb2d0, 0x94d15b4a, 0x2594456f, 0x4d9acdda, 0x6d4dd7b7,
    0x55aaadd6, 0x6b55ffbd, 0x3468d01a, 0x0d345c17, 0xaea5b357, 0xd7ae0b80,
    0x52a4b129, 0xe852f6c1, 0x7efc013f, 0xe37e82dc, 0x9dc37fb2, 0x599d5eeb,
    0x4a94d125, 0xee4adecb, 0xf7172e87, 0xbff7e038, 0x80f90b40, 0x20807960,
    0xf0193278, 0x3cf0e944, 0xd059b268, 0x34d0895c, 0x90d94b48, 0x2490496c,
    0xa7b797af, 0xaba71004, 0xe8295274, 0x3ae8c14e, 0x9fc777b3, 0xa59f5816,
    0x50a0b928, 0x1450f03c, 0xd553a696, 0x4bd586dd, 0xd15bb694, 0x4ad18ade,
    0x98c96b4c, 0x2698516a, 0xcc61c266, 0x33ccad55, 0xa0b98b50, 0x28a01978,
    0x172e5cf7, 0x87173970, 0xf411227a, 0x3df4e547, 0xb695d35b, 0xd1b6238a,
    0xc17bf69c, 0x4ec1bad2, 0x2850a014, 0x0a28781e, 0x5fbe85d3, 0x955fe146,
    0x264c9813, 0xf5266ae6, 0x010204fc, 0x7e010382, 0xabafa7a9, 0xa8ab0401,
    0x254a94ee, 0x77256f99, 0x3870e01c, 0x0e384812, 0x82fd0341, 0xdc827f9d,
    0x7dfa0dc2, 0x617d87a3, 0x4890d924, 0x1248d836, 0xfc01027e, 0x3ffcfd41,
    0x1b366cf1, 0x841b2d75, 0xce65ca67, 0xcfceaba8, 0x3f7efce3, 0x8d3f416e,
    0x6bd655c9, 0x986bbd51, 0xe23d7a71, 0xc4e2dfb5, 0x67ce65cf, 0x9b67a954,
    0x66cc6133, 0xe566aad6, 0x4386f5dd, 0x9243c54f, 0x59b29dd0, 0x6859ebb8,
    0x193264f0, 0x78192b88, 0x84f11b42, 0x21847563, 0x3d7af4e2, 0x713d4793,
    0xf5132686, 0x43f5e6c5, 0x2f5ebceb, 0x892f7162, 0xc96bd698, 0x4cc9a2d4,
    0xbc81fb5e, 0x2fbc3d71, 0xd94b9690, 0x48d992d8, 0x95d35fb6, 0x5b9546ed,
    0x2952a4e8, 0x74297b9c, 0x4182fddc, 0x6e41c3b2, 0xda4d9a6d, 0xcada97a7,
    0x1a34680d, 0xfa1a2ef7, 0xb099cb58, 0x2cb02974, 0xe92b5688, 0x44e9c2cc,
    0x69d25dc8, 0x6469bbac, 0xd25dba69, 0xc8d28fa1, 0x7bf615c1, 0x9c7b8d5d,
    0xd757ae97, 0xb7d78020, 0x112244f4, 0x7a11338e, 0x9bcf67b1, 0xa49b5415,
    0x3366cce5, 0x8e33556b, 0x8aed2345, 0xde8a679b, 0x23468ced, 0x8a236567,
    0x091224f8, 0x7c091b84, 0xd451a26a, 0x35d4855f, 0x71e23dc4, 0x627193a6,
    0x4488e922, 0x1144cc33, 0x68d05934, 0x1a68b82e, 0x6fde45cb, 0x996fb152,
    0xf21d3a79, 0xc0f2efb9, 0x0e1c3807, 0xff0e12f8, 0xdf478e93, 0xb5df9826,
    0x87f717bf, 0xa387701c, 0xdc41826e, 0x37dc9d59, 0x83ff07bd, 0xa2837c1f,
    0x1830600c, 0x0618280a, 0x6ad45135, 0xe66abed3, 0xee254a77, 0xc7eecbb0,
    0x99cb6fb0, 0x589952e8, 0x81fb0fbc, 0x5e817ae2, 0x62c47131, 0xe462a6d5,
    0x366cd81b, 0xf1365aea, 0x2e5cb817, 0xf72e72e0, 0x7af4113d, 0xe27a8edf,
    0xfe050a7f, 0xc3fefbbc, 0x458aedde, 0x6f45cfb1, 0x9cc17b4e, 0x279c5d69,
    0x75ea2dc6, 0x63759fa5, 0x91db4fb4, 0x5a914aee, 0x0c183006, 0x030c1405,
    0x0f1e3cfb, 0x810f117a, 0xe7376e8f, 0xbbe7d034, 0xf6152a7b, 0xc1f6e3ba,
    0x1428500a, 0x05143c0f, 0x63c675cd, 0x9a63a557, 0x1d3a74f2, 0x791d278b,
    0x0b162cf9, 0x800b1d79, 0x8bef27b9, 0xa08b6419, 0xb39fc7a5, 0xaeb32c0b,
    0xf31f3e85, 0xbef3ec3b, 0xb29dc359, 0xd0b22f89, 0x3b76ece1, 0x8c3b4d6d,
    0x08102004, 0x02081806, 0x4b96d5d9, 0x904bdd49, 0x10204008, 0x0410300c,
    0xa6b59353, 0xd5a61386, 0x3264c819, 0xf03256e9, 0xb98befa0, 0x50b932f0,
    0xa8a9ab54, 0x2aa8017e, 0x92dd4349, 0xd8924f91, 0xf11b3684, 0x42f1eac6,
    0x56aca12b, 0xe956fac2, 0xdd438692, 0x49dd9edb, 0x214284ec, 0x7621639a,
    0xbf87f7a3, 0xadbf380e, 0x04081002, 0x01040c03, 0xbe85f35f, 0xd3be3b8c,
    0xd655aa6b, 0xc9d683a2, 0xfd030682, 0x41fdfec3, 0x77ee25c7, 0x9f779958,
    0xea2d5a75, 0xc6eac7b3, 0x3a74e81d, 0xf23a4eef, 0xc869d264, 0x32c8a156,
    0x8fe737bb, 0xa18f681a, 0x57aea5d7, 0x9757f940, 0x1e3c780f, 0xfb1e22f4,
    0xfa0d1a7d, 0xc2faf7bf, 0x2b56ace9, 0x882b7d61, 0x58b0992c, 0x1658e83a,
    0xc573e69e, 0x4fc5b6d1, 0x274e9cef, 0x8b276964, 0xaca1bb56, 0x2bac0d7d,
    0xe33f7e8d, 0xbae3dc37, 0xed23468a, 0x45edcecf, 0x97d757b7, 0xa7974010,
    0xbb8fe7a1, 0xacbb340d, 0x468ce123, 0xed46cace, 0x050a14fe, 0x7f050f81,
    0x4080f920, 0x1040c030, 0x3162c4e4, 0x72315396, 0xe533668e, 0x47e5d6c9,
    0x376edce7, 0x8f375968, 0x2c58b016, 0x0b2c741d, 0x9ec5734f, 0xdb9e5b94,
    0x0a142805, 0xfe0a1efb, 0xb19bcfa4, 0x52b12af6, 0xb593dfa6, 0x53b526f5,
    0x060c1803, 0xfd060afe, 0x6cd84936, 0x1b6cb42d, 0x1f3e7cf3, 0x851f2176,
    0xa3bf87ad, 0xaaa31c07, 0x2a54a815, 0xf62a7ee3, 0x70e03938, 0x1c709024,
    0xff070e83, 0xbdfff83e, 0xba8de35d, 0xd2ba378f, 0x070e1cff, 0x8307097c,
    0x24489012, 0x09246c1b, 0x162c580b, 0xf9163af2, 0xc675ea63, 0xcdc6b3ae,
    0x61c27dcc, 0x6661a3aa};

const DWORD tbsm4_128[512] = {
    0x5d8dd269, 0x5de7bbba, 0xde8a6fcb, 0xde9ba445, 0x00000000, 0x00000000,
    0xb7d7a7af, 0xb7200897, 0xd3be95b6, 0xd38c235f, 0xcada65ce, 0xcaa7ab6d,
    0x3cf01e0f, 0x3c441178, 0x0d34fa7d, 0x0d17871a, 0xc3fe9db2, 0xc3bc2f7f,
    0xf8127c3e, 0xf8f14209, 0xcbde99b0, 0xcba4296f, 0x8d3fba5d, 0x8d6ee7e3,
    0x76213be1, 0x769adaec, 0x892fb85c, 0x8962e4eb, 0xaaa355d6, 0xaa0783ad,
    0x124809f8, 0x1236f124, 0x882b4422, 0x886166e9, 0x228811f4, 0x2266e544,
    0x4fc5db91, 0x4fd14a9e, 0xdb9e91b4, 0xdb94254f, 0x6d4dca65, 0x6db7afda,
    0x47e5df93, 0x47c94c8e, 0xe4627239, 0xe4d54b31, 0x4cc92613, 0x4cd43598,
    0x78193c1e, 0x788822f0, 0x9a634dda, 0x9a5797cd, 0x49ddd86c, 0x49dbb492,
    0x9347b5a6, 0x934c13df, 0xc4e26231, 0xc4b55371, 0xc0f26030, 0xc0b95079,
    0x861343dd, 0x86739ef5, 0x134cf586, 0x13357326, 0xa9afa854, 0xa902fcab,
    0x20801008, 0x20601840, 0x53b5d596, 0x53f543a6, 0x1c700e07, 0x1c240938,
    0x4ec127ef, 0x4ed2c89c, 0xcfce9bb1, 0xcfa82a67, 0x35d4e673, 0x355f956a,
    0x39e4e070, 0x394b9072, 0xb4db5a2d, 0xb4257791, 0xa18fac56, 0xa11afabb,
    0x54a92a15, 0x54fc3fa8, 0x64693219, 0x64ac2bc8, 0x030cfd82, 0x03057f06,
    0xc7ee9fb3, 0xc7b02c77, 0x851fbe5f, 0x8576e1f3, 0x5c892e17, 0x5ce439b8,
    0x5b95d194, 0x5bed45b6, 0xcdc69a4d, 0xcdaed763, 0xd8926c36, 0xd8915a49,
    0x723139e0, 0x7296d9e4, 0x96534bd9, 0x964392d5, 0x42f121ec, 0x42c6cd84,
    0xb8eb5c2e, 0xb8317289, 0xe1768c46, 0xe1daca3b, 0xa28351d4, 0xa21f85bd,
    0x60793018, 0x60a028c0, 0xef4e8bb9, 0xefc83227, 0xbdffa251, 0xbd3ef383,
    0x020801fc, 0x0206fd04, 0xafb7aba9, 0xaf0802a7, 0x8c3b4623, 0x8c6d65e1,
    0x7335c59e, 0x73955be6, 0x7c093e1f, 0x7c8421f8, 0x7f05c39d, 0x7f815efe,
    0x5e812feb, 0x5ee2c4bc, 0xf9168040, 0xf9f2c00b, 0x656dce67, 0x65afa9ca,
    0xe66a73c5, 0xe6d3b635, 0xeb5e89b8, 0xebc4312f, 0xadbfaa55, 0xad0effa3,
    0x5a912dea, 0x5aeec7b4, 0xa59fae57, 0xa516f9b3, 0x791dc060, 0x798ba0f2,
    0x8e3347df, 0x8e6b98e5, 0x1554f67b, 0x153f8d2a, 0x30c0180c, 0x30501460,
    0xec42763b, 0xeccd4d21, 0xa49b5229, 0xa4157bb1, 0xc2fa61cc, 0xc2bfad7d,
    0x3ef81ff3, 0x3e42ec7c, 0xe0727038, 0xe0d94839, 0x74293a1d, 0x749c27e8,
    0x51bdd46a, 0x51f3bea2, 0xfb1e81bc, 0xfbf43d0f, 0x2db4ea75, 0x2d779f5a,
    0x6e4137e7, 0x6eb2d0dc, 0x945b4a25, 0x94456fd1, 0x4dcdda6d, 0x4dd7b79a,
    0x55add66b, 0x55ffbdaa, 0x34d01a0d, 0x345c1768, 0xaeb357d7, 0xae0b80a5,
    0x52b129e8, 0x52f6c1a4, 0x7e013fe3, 0x7e82dcfc, 0x9d7fb259, 0x9d5eebc3,
    0x4ad125ee, 0x4adecb94, 0xf72e87bf, 0xf7e03817, 0x800b4020, 0x807960f9,
    0xf032783c, 0xf0e94419, 0xd0b26834, 0xd0895c59, 0x904b4824, 0x90496cd9,
    0xa797afab, 0xa71004b7, 0xe852743a, 0xe8c14e29, 0x9f77b3a5, 0x9f5816c7,
    0x50b92814, 0x50f03ca0, 0xd5a6964b, 0xd586dd53, 0xd1b6944a, 0xd18ade5b,
    0x986b4c26, 0x98516ac9, 0xccc26633, 0xccad5561, 0xa08b5028, 0xa01978b9,
    0x175cf787, 0x1739702e, 0xf4227a3d, 0xf4e54711, 0xb6d35bd1, 0xb6238a95,
    0xc1f69c4e, 0xc1bad27b, 0x28a0140a, 0x28781e50, 0x5f85d395, 0x5fe146be,
    0x269813f5, 0x266ae64c, 0x0104fc7e, 0x01038202, 0xaba7a9a8, 0xab0401af,
    0x2594ee77, 0x256f994a, 0x38e01c0e, 0x38481270, 0x820341dc, 0x827f9dfd,
    0x7d0dc261, 0x7d87a3fa, 0x48d92412, 0x48d83690, 0xfc027e3f, 0xfcfd4101,
    0x1b6cf184, 0x1b2d7536, 0xceca67cf, 0xceaba865, 0x3ffce38d, 0x3f416e7e,
    0x6b55c998, 0x6bbd51d6, 0xe27a71c4, 0xe2dfb53d, 0x6765cf9b, 0x67a954ce,
    0x666133e5, 0x66aad6cc, 0x43f5dd92, 0x43c54f86, 0x599dd068, 0x59ebb8b2,
    0x1964f078, 0x192b8832, 0x841b4221, 0x847563f1, 0x3df4e271, 0x3d47937a,
    0xf5268643, 0xf5e6c513, 0x2fbceb89, 0x2f71625e, 0xc9d6984c, 0xc9a2d46b,
    0xbcfb5e2f, 0xbc3d7181, 0xd9969048, 0xd992d84b, 0x955fb65b, 0x9546edd3,
    0x29a4e874, 0x297b9c52, 0x41fddc6e, 0x41c3b282, 0xda9a6dca, 0xda97a74d,
    0x1a680dfa, 0x1a2ef734, 0xb0cb582c, 0xb0297499, 0xe9568844, 0xe9c2cc2b,
    0x695dc864, 0x69bbacd2, 0xd2ba69c8, 0xd28fa15d, 0x7b15c19c, 0x7b8d5df6,
    0xd7ae97b7, 0xd7802057, 0x1144f47a, 0x11338e22, 0x9b67b1a4, 0x9b5415cf,
    0x33cce58e, 0x33556b66, 0x8a2345de, 0x8a679bed, 0x238ced8a, 0x23656746,
    0x0924f87c, 0x091b8412, 0xd4a26a35, 0xd4855f51, 0x713dc462, 0x7193a6e2,
    0x44e92211, 0x44cc3388, 0x6859341a, 0x68b82ed0, 0x6f45cb99, 0x6fb152de,
    0xf23a79c0, 0xf2efb91d, 0x0e3807ff, 0x0e12f81c, 0xdf8e93b5, 0xdf982647,
    0x8717bfa3, 0x87701cf7, 0xdc826e37, 0xdc9d5941, 0x8307bda2, 0x837c1fff,
    0x18600c06, 0x18280a30, 0x6a5135e6, 0x6abed3d4, 0xee4a77c7, 0xeecbb025,
    0x996fb058, 0x9952e8cb, 0x810fbc5e, 0x817ae2fb, 0x627131e4, 0x62a6d5c4,
    0x36d81bf1, 0x365aea6c, 0x2eb817f7, 0x2e72e05c, 0x7a113de2, 0x7a8edff4,
    0xfe0a7fc3, 0xfefbbc05, 0x45edde6f, 0x45cfb18a, 0x9c7b4e27, 0x9c5d69c1,
    0x752dc663, 0x759fa5ea, 0x914fb45a, 0x914aeedb, 0x0c300603, 0x0c140518,
    0x0f3cfb81, 0x0f117a1e, 0xe76e8fbb, 0xe7d03437, 0xf62a7bc1, 0xf6e3ba15,
    0x14500a05, 0x143c0f28, 0x6375cd9a, 0x63a557c6, 0x1d74f279, 0x1d278b3a,
    0x0b2cf980, 0x0b1d7916, 0x8b27b9a0, 0x8b6419ef, 0xb3c7a5ae, 0xb32c0b9f,
    0xf33e85be, 0xf3ec3b1f, 0xb2c359d0, 0xb22f899d, 0x3bece18c, 0x3b4d6d76,
    0x08200402, 0x08180610, 0x4bd5d990, 0x4bdd4996, 0x10400804, 0x10300c20,
    0xa69353d5, 0xa61386b5, 0x32c819f0, 0x3256e964, 0xb9efa050, 0xb932f08b,
    0xa8ab542a, 0xa8017ea9, 0x924349d8, 0x924f91dd, 0xf1368442, 0xf1eac61b,
    0x56a12be9, 0x56fac2ac, 0xdd869249, 0xdd9edb43, 0x2184ec76, 0x21639a42,
    0xbff7a3ad, 0xbf380e87, 0x04100201, 0x040c0308, 0xbef35fd3, 0xbe3b8c85,
    0xd6aa6bc9, 0xd683a255, 0xfd068241, 0xfdfec303, 0x7725c79f, 0x779958ee,
    0xea5a75c6, 0xeac7b32d, 0x3ae81df2, 0x3a4eef74, 0xc8d26432, 0xc8a15669,
    0x8f37bba1, 0x8f681ae7, 0x57a5d797, 0x57f940ae, 0x1e780ffb, 0x1e22f43c,
    0xfa1a7dc2, 0xfaf7bf0d, 0x2bace988, 0x2b7d6156, 0x58992c16, 0x58e83ab0,
    0xc5e69e4f, 0xc5b6d173, 0x279cef8b, 0x2769644e, 0xacbb562b, 0xac0d7da1,
    0xe37e8dba, 0xe3dc373f, 0xed468a45, 0xedcecf23, 0x9757b7a7, 0x974010d7,
    0xbbe7a1ac, 0xbb340d8f, 0x46e123ed, 0x46cace8c, 0x0514fe7f, 0x050f810a,
    0x40f92010, 0x40c03080, 0x31c4e472, 0x31539662, 0xe5668e47, 0xe5d6c933,
    0x37dce78f, 0x3759686e, 0x2cb0160b, 0x2c741d58, 0x9e734fdb, 0x9e5b94c5,
    0x0a2805fe, 0x0a1efb14, 0xb1cfa452, 0xb12af69b, 0xb5dfa653, 0xb526f593,
    0x061803fd, 0x060afe0c, 0x6c49361b, 0x6cb42dd8, 0x1f7cf385, 0x1f21763e,
    0xa387adaa, 0xa31c07bf, 0x2aa815f6, 0x2a7ee354, 0x7039381c, 0x709024e0,
    0xff0e83bd, 0xfff83e07, 0xbae35dd2, 0xba378f8d, 0x071cff83, 0x07097c0e,
    0x24901209, 0x246c1b48, 0x16580bf9, 0x163af22c, 0xc6ea63cd, 0xc6b3ae75,
    0x617dcc66, 0x61a3aac2};

const DWORD tbsm5_128[512] = {
    0x5dd2695d, 0xe7bbba8d, 0xde6fcbde, 0x9ba4458a, 0x00000000, 0x00000000,
    0xb7a7afb7, 0x200897d7, 0xd395b6d3, 0x8c235fbe, 0xca65ceca, 0xa7ab6dda,
    0x3c1e0f3c, 0x441178f0, 0x0dfa7d0d, 0x17871a34, 0xc39db2c3, 0xbc2f7ffe,
    0xf87c3ef8, 0xf1420912, 0xcb99b0cb, 0xa4296fde, 0x8dba5d8d, 0x6ee7e33f,
    0x763be176, 0x9adaec21, 0x89b85c89, 0x62e4eb2f, 0xaa55d6aa, 0x0783ada3,
    0x1209f812, 0x36f12448, 0x88442288, 0x6166e92b, 0x2211f422, 0x66e54488,
    0x4fdb914f, 0xd14a9ec5, 0xdb91b4db, 0x94254f9e, 0x6dca656d, 0xb7afda4d,
    0x47df9347, 0xc94c8ee5, 0xe47239e4, 0xd54b3162, 0x4c26134c, 0xd43598c9,
    0x783c1e78, 0x8822f019, 0x9a4dda9a, 0x5797cd63, 0x49d86c49, 0xdbb492dd,
    0x93b5a693, 0x4c13df47, 0xc46231c4, 0xb55371e2, 0xc06030c0, 0xb95079f2,
    0x8643dd86, 0x739ef513, 0x13f58613, 0x3573264c, 0xa9a854a9, 0x02fcabaf,
    0x20100820, 0x60184080, 0x53d59653, 0xf543a6b5, 0x1c0e071c, 0x24093870,
    0x4e27ef4e, 0xd2c89cc1, 0xcf9bb1cf, 0xa82a67ce, 0x35e67335, 0x5f956ad4,
    0x39e07039, 0x4b9072e4, 0xb45a2db4, 0x257791db, 0xa1ac56a1, 0x1afabb8f,
    0x542a1554, 0xfc3fa8a9, 0x64321964, 0xac2bc869, 0x03fd8203, 0x057f060c,
    0xc79fb3c7, 0xb02c77ee, 0x85be5f85, 0x76e1f31f, 0x5c2e175c, 0xe439b889,
    0x5bd1945b, 0xed45b695, 0xcd9a4dcd, 0xaed763c6, 0xd86c36d8, 0x915a4992,
    0x7239e072, 0x96d9e431, 0x964bd996, 0x4392d553, 0x4221ec42, 0xc6cd84f1,
    0xb85c2eb8, 0x317289eb, 0xe18c46e1, 0xdaca3b76, 0xa251d4a2, 0x1f85bd83,
    0x60301860, 0xa028c079, 0xef8bb9ef, 0xc832274e, 0xbda251bd, 0x3ef383ff,
    0x0201fc02, 0x06fd0408, 0xafaba9af, 0x0802a7b7, 0x8c46238c, 0x6d65e13b,
    0x73c59e73, 0x955be635, 0x7c3e1f7c, 0x8421f809, 0x7fc39d7f, 0x815efe05,
    0x5e2feb5e, 0xe2c4bc81, 0xf98040f9, 0xf2c00b16, 0x65ce6765, 0xafa9ca6d,
    0xe673c5e6, 0xd3b6356a, 0xeb89b8eb, 0xc4312f5e, 0xadaa55ad, 0x0effa3bf,
    0x5a2dea5a, 0xeec7b491, 0xa5ae57a5, 0x16f9b39f, 0x79c06079, 0x8ba0f21d,
    0x8e47df8e, 0x6b98e533, 0x15f67b15, 0x3f8d2a54, 0x30180c30, 0x501460c0,
    0xec763bec, 0xcd4d2142, 0xa45229a4, 0x157bb19b, 0xc261ccc2, 0xbfad7dfa,
    0x3e1ff33e, 0x42ec7cf8, 0xe07038e0, 0xd9483972, 0x743a1d74, 0x9c27e829,
    0x51d46a51, 0xf3bea2bd, 0xfb81bcfb, 0xf43d0f1e, 0x2dea752d, 0x779f5ab4,
    0x6e37e76e, 0xb2d0dc41, 0x944a2594, 0x456fd15b, 0x4dda6d4d, 0xd7b79acd,
    0x55d66b55, 0xffbdaaad, 0x341a0d34, 0x5c1768d0, 0xae57d7ae, 0x0b80a5b3,
    0x5229e852, 0xf6c1a4b1, 0x7e3fe37e, 0x82dcfc01, 0x9db2599d, 0x5eebc37f,
    0x4a25ee4a, 0xdecb94d1, 0xf787bff7, 0xe038172e, 0x80402080, 0x7960f90b,
    0xf0783cf0, 0xe9441932, 0xd06834d0, 0x895c59b2, 0x90482490, 0x496cd94b,
    0xa7afaba7, 0x1004b797, 0xe8743ae8, 0xc14e2952, 0x9fb3a59f, 0x5816c777,
    0x50281450, 0xf03ca0b9, 0xd5964bd5, 0x86dd53a6, 0xd1944ad1, 0x8ade5bb6,
    0x984c2698, 0x516ac96b, 0xcc6633cc, 0xad5561c2, 0xa05028a0, 0x1978b98b,
    0x17f78717, 0x39702e5c, 0xf47a3df4, 0xe5471122, 0xb65bd1b6, 0x238a95d3,
    0xc19c4ec1, 0xbad27bf6, 0x28140a28, 0x781e50a0, 0x5fd3955f, 0xe146be85,
    0x2613f526, 0x6ae64c98, 0x01fc7e01, 0x03820204, 0xaba9a8ab, 0x0401afa7,
    0x25ee7725, 0x6f994a94, 0x381c0e38, 0x481270e0, 0x8241dc82, 0x7f9dfd03,
    0x7dc2617d, 0x87a3fa0d, 0x48241248, 0xd83690d9, 0xfc7e3ffc, 0xfd410102,
    0x1bf1841b, 0x2d75366c, 0xce67cfce, 0xaba865ca, 0x3fe38d3f, 0x416e7efc,
    0x6bc9986b, 0xbd51d655, 0xe271c4e2, 0xdfb53d7a, 0x67cf9b67, 0xa954ce65,
    0x6633e566, 0xaad6cc61, 0x43dd9243, 0xc54f86f5, 0x59d06859, 0xebb8b29d,
    0x19f07819, 0x2b883264, 0x84422184, 0x7563f11b, 0x3de2713d, 0x47937af4,
    0xf58643f5, 0xe6c51326, 0x2feb892f, 0x71625ebc, 0xc9984cc9, 0xa2d46bd6,
    0xbc5e2fbc, 0x3d7181fb, 0xd99048d9, 0x92d84b96, 0x95b65b95, 0x46edd35f,
    0x29e87429, 0x7b9c52a4, 0x41dc6e41, 0xc3b282fd, 0xda6dcada, 0x97a74d9a,
    0x1a0dfa1a, 0x2ef73468, 0xb0582cb0, 0x297499cb, 0xe98844e9, 0xc2cc2b56,
    0x69c86469, 0xbbacd25d, 0xd269c8d2, 0x8fa15dba, 0x7bc19c7b, 0x8d5df615,
    0xd797b7d7, 0x802057ae, 0x11f47a11, 0x338e2244, 0x9bb1a49b, 0x5415cf67,
    0x33e58e33, 0x556b66cc, 0x8a45de8a, 0x679bed23, 0x23ed8a23, 0x6567468c,
    0x09f87c09, 0x1b841224, 0xd46a35d4, 0x855f51a2, 0x71c46271, 0x93a6e23d,
    0x44221144, 0xcc3388e9, 0x68341a68, 0xb82ed059, 0x6fcb996f, 0xb152de45,
    0xf279c0f2, 0xefb91d3a, 0x0e07ff0e, 0x12f81c38, 0xdf93b5df, 0x9826478e,
    0x87bfa387, 0x701cf717, 0xdc6e37dc, 0x9d594182, 0x83bda283, 0x7c1fff07,
    0x180c0618, 0x280a3060, 0x6a35e66a, 0xbed3d451, 0xee77c7ee, 0xcbb0254a,
    0x99b05899, 0x52e8cb6f, 0x81bc5e81, 0x7ae2fb0f, 0x6231e462, 0xa6d5c471,
    0x361bf136, 0x5aea6cd8, 0x2e17f72e, 0x72e05cb8, 0x7a3de27a, 0x8edff411,
    0xfe7fc3fe, 0xfbbc050a, 0x45de6f45, 0xcfb18aed, 0x9c4e279c, 0x5d69c17b,
    0x75c66375, 0x9fa5ea2d, 0x91b45a91, 0x4aeedb4f, 0x0c06030c, 0x14051830,
    0x0ffb810f, 0x117a1e3c, 0xe78fbbe7, 0xd034376e, 0xf67bc1f6, 0xe3ba152a,
    0x140a0514, 0x3c0f2850, 0x63cd9a63, 0xa557c675, 0x1df2791d, 0x278b3a74,
    0x0bf9800b, 0x1d79162c, 0x8bb9a08b, 0x6419ef27, 0xb3a5aeb3, 0x2c0b9fc7,
    0xf385bef3, 0xec3b1f3e, 0xb259d0b2, 0x2f899dc3, 0x3be18c3b, 0x4d6d76ec,
    0x08040208, 0x18061020, 0x4bd9904b, 0xdd4996d5, 0x10080410, 0x300c2040,
    0xa653d5a6, 0x1386b593, 0x3219f032, 0x56e964c8, 0xb9a050b9, 0x32f08bef,
    0xa8542aa8, 0x017ea9ab, 0x9249d892, 0x4f91dd43, 0xf18442f1, 0xeac61b36,
    0x562be956, 0xfac2aca1, 0xdd9249dd, 0x9edb4386, 0x21ec7621, 0x639a4284,
    0xbfa3adbf, 0x380e87f7, 0x04020104, 0x0c030810, 0xbe5fd3be, 0x3b8c85f3,
    0xd66bc9d6, 0x83a255aa, 0xfd8241fd, 0xfec30306, 0x77c79f77, 0x9958ee25,
    0xea75c6ea, 0xc7b32d5a, 0x3a1df23a, 0x4eef74e8, 0xc86432c8, 0xa15669d2,
    0x8fbba18f, 0x681ae737, 0x57d79757, 0xf940aea5, 0x1e0ffb1e, 0x22f43c78,
    0xfa7dc2fa, 0xf7bf0d1a, 0x2be9882b, 0x7d6156ac, 0x582c1658, 0xe83ab099,
    0xc59e4fc5, 0xb6d173e6, 0x27ef8b27, 0x69644e9c, 0xac562bac, 0x0d7da1bb,
    0xe38dbae3, 0xdc373f7e, 0xed8a45ed, 0xcecf2346, 0x97b7a797, 0x4010d757,
    0xbba1acbb, 0x340d8fe7, 0x4623ed46, 0xcace8ce1, 0x05fe7f05, 0x0f810a14,
    0x40201040, 0xc03080f9, 0x31e47231, 0x539662c4, 0xe58e47e5, 0xd6c93366,
    0x37e78f37, 0x59686edc, 0x2c160b2c, 0x741d58b0, 0x9e4fdb9e, 0x5b94c573,
    0x0a05fe0a, 0x1efb1428, 0xb1a452b1, 0x2af69bcf, 0xb5a653b5, 0x26f593df,
    0x0603fd06, 0x0afe0c18, 0x6c361b6c, 0xb42dd849, 0x1ff3851f, 0x21763e7c,
    0xa3adaaa3, 0x1c07bf87, 0x2a15f62a, 0x7ee354a8, 0x70381c70, 0x9024e039,
    0xff83bdff, 0xf83e070e, 0xba5dd2ba, 0x378f8de3, 0x07ff8307, 0x097c0e1c,
    0x24120924, 0x6c1b4890, 0x160bf916, 0x3af22c58, 0xc663cdc6, 0xb3ae75ea,
    0x61cc6661, 0xa3aac27d};

const DWORD tbsm6_128[512] = {
    0x5d695de7, 0xbbba8dd2, 0xdecbde9b, 0xa4458a6f, 0x00000000, 0x00000000,
    0xb7afb720, 0x0897d7a7, 0xd3b6d38c, 0x235fbe95, 0xcacecaa7, 0xab6dda65,
    0x3c0f3c44, 0x1178f01e, 0x0d7d0d17, 0x871a34fa, 0xc3b2c3bc, 0x2f7ffe9d,
    0xf83ef8f1, 0x4209127c, 0xcbb0cba4, 0x296fde99, 0x8d5d8d6e, 0xe7e33fba,
    0x76e1769a, 0xdaec213b, 0x895c8962, 0xe4eb2fb8, 0xaad6aa07, 0x83ada355,
    0x12f81236, 0xf1244809, 0x88228861, 0x66e92b44, 0x22f42266, 0xe5448811,
    0x4f914fd1, 0x4a9ec5db, 0xdbb4db94, 0x254f9e91, 0x6d656db7, 0xafda4dca,
    0x479347c9, 0x4c8ee5df, 0xe439e4d5, 0x4b316272, 0x4c134cd4, 0x3598c926,
    0x781e7888, 0x22f0193c, 0x9ada9a57, 0x97cd634d, 0x496c49db, 0xb492ddd8,
    0x93a6934c, 0x13df47b5, 0xc431c4b5, 0x5371e262, 0xc030c0b9, 0x5079f260,
    0x86dd8673, 0x9ef51343, 0x13861335, 0x73264cf5, 0xa954a902, 0xfcabafa8,
    0x20082060, 0x18408010, 0x539653f5, 0x43a6b5d5, 0x1c071c24, 0x0938700e,
    0x4eef4ed2, 0xc89cc127, 0xcfb1cfa8, 0x2a67ce9b, 0x3573355f, 0x956ad4e6,
    0x3970394b, 0x9072e4e0, 0xb42db425, 0x7791db5a, 0xa156a11a, 0xfabb8fac,
    0x541554fc, 0x3fa8a92a, 0x641964ac, 0x2bc86932, 0x03820305, 0x7f060cfd,
    0xc7b3c7b0, 0x2c77ee9f, 0x855f8576, 0xe1f31fbe, 0x5c175ce4, 0x39b8892e,
    0x5b945bed, 0x45b695d1, 0xcd4dcdae, 0xd763c69a, 0xd836d891, 0x5a49926c,
    0x72e07296, 0xd9e43139, 0x96d99643, 0x92d5534b, 0x42ec42c6, 0xcd84f121,
    0xb82eb831, 0x7289eb5c, 0xe146e1da, 0xca3b768c, 0xa2d4a21f, 0x85bd8351,
    0x601860a0, 0x28c07930, 0xefb9efc8, 0x32274e8b, 0xbd51bd3e, 0xf383ffa2,
    0x02fc0206, 0xfd040801, 0xafa9af08, 0x02a7b7ab, 0x8c238c6d, 0x65e13b46,
    0x739e7395, 0x5be635c5, 0x7c1f7c84, 0x21f8093e, 0x7f9d7f81, 0x5efe05c3,
    0x5eeb5ee2, 0xc4bc812f, 0xf940f9f2, 0xc00b1680, 0x656765af, 0xa9ca6dce,
    0xe6c5e6d3, 0xb6356a73, 0xebb8ebc4, 0x312f5e89, 0xad55ad0e, 0xffa3bfaa,
    0x5aea5aee, 0xc7b4912d, 0xa557a516, 0xf9b39fae, 0x7960798b, 0xa0f21dc0,
    0x8edf8e6b, 0x98e53347, 0x157b153f, 0x8d2a54f6, 0x300c3050, 0x1460c018,
    0xec3beccd, 0x4d214276, 0xa429a415, 0x7bb19b52, 0xc2ccc2bf, 0xad7dfa61,
    0x3ef33e42, 0xec7cf81f, 0xe038e0d9, 0x48397270, 0x741d749c, 0x27e8293a,
    0x516a51f3, 0xbea2bdd4, 0xfbbcfbf4, 0x3d0f1e81, 0x2d752d77, 0x9f5ab4ea,
    0x6ee76eb2, 0xd0dc4137, 0x94259445, 0x6fd15b4a, 0x4d6d4dd7, 0xb79acdda,
    0x556b55ff, 0xbdaaadd6, 0x340d345c, 0x1768d01a, 0xaed7ae0b, 0x80a5b357,
    0x52e852f6, 0xc1a4b129, 0x7ee37e82, 0xdcfc013f, 0x9d599d5e, 0xebc37fb2,
    0x4aee4ade, 0xcb94d125, 0xf7bff7e0, 0x38172e87, 0x80208079, 0x60f90b40,
    0xf03cf0e9, 0x44193278, 0xd034d089, 0x5c59b268, 0x90249049, 0x6cd94b48,
    0xa7aba710, 0x04b797af, 0xe83ae8c1, 0x4e295274, 0x9fa59f58, 0x16c777b3,
    0x501450f0, 0x3ca0b928, 0xd54bd586, 0xdd53a696, 0xd14ad18a, 0xde5bb694,
    0x98269851, 0x6ac96b4c, 0xcc33ccad, 0x5561c266, 0xa028a019, 0x78b98b50,
    0x17871739, 0x702e5cf7, 0xf43df4e5, 0x4711227a, 0xb6d1b623, 0x8a95d35b,
    0xc14ec1ba, 0xd27bf69c, 0x280a2878, 0x1e50a014, 0x5f955fe1, 0x46be85d3,
    0x26f5266a, 0xe64c9813, 0x017e0103, 0x820204fc, 0xaba8ab04, 0x01afa7a9,
    0x2577256f, 0x994a94ee, 0x380e3848, 0x1270e01c, 0x82dc827f, 0x9dfd0341,
    0x7d617d87, 0xa3fa0dc2, 0x481248d8, 0x3690d924, 0xfc3ffcfd, 0x4101027e,
    0x1b841b2d, 0x75366cf1, 0xcecfceab, 0xa865ca67, 0x3f8d3f41, 0x6e7efce3,
    0x6b986bbd, 0x51d655c9, 0xe2c4e2df, 0xb53d7a71, 0x679b67a9, 0x54ce65cf,
    0x66e566aa, 0xd6cc6133, 0x439243c5, 0x4f86f5dd, 0x596859eb, 0xb8b29dd0,
    0x1978192b, 0x883264f0, 0x84218475, 0x63f11b42, 0x3d713d47, 0x937af4e2,
    0xf543f5e6, 0xc5132686, 0x2f892f71, 0x625ebceb, 0xc94cc9a2, 0xd46bd698,
    0xbc2fbc3d, 0x7181fb5e, 0xd948d992, 0xd84b9690, 0x955b9546, 0xedd35fb6,
    0x2974297b, 0x9c52a4e8, 0x416e41c3, 0xb282fddc, 0xdacada97, 0xa74d9a6d,
    0x1afa1a2e, 0xf734680d, 0xb02cb029, 0x7499cb58, 0xe944e9c2, 0xcc2b5688,
    0x696469bb, 0xacd25dc8, 0xd2c8d28f, 0xa15dba69, 0x7b9c7b8d, 0x5df615c1,
    0xd7b7d780, 0x2057ae97, 0x117a1133, 0x8e2244f4, 0x9ba49b54, 0x15cf67b1,
    0x338e3355, 0x6b66cce5, 0x8ade8a67, 0x9bed2345, 0x238a2365, 0x67468ced,
    0x097c091b, 0x841224f8, 0xd435d485, 0x5f51a26a, 0x71627193, 0xa6e23dc4,
    0x441144cc, 0x3388e922, 0x681a68b8, 0x2ed05934, 0x6f996fb1, 0x52de45cb,
    0xf2c0f2ef, 0xb91d3a79, 0x0eff0e12, 0xf81c3807, 0xdfb5df98, 0x26478e93,
    0x87a38770, 0x1cf717bf, 0xdc37dc9d, 0x5941826e, 0x83a2837c, 0x1fff07bd,
    0x18061828, 0x0a30600c, 0x6ae66abe, 0xd3d45135, 0xeec7eecb, 0xb0254a77,
    0x99589952, 0xe8cb6fb0, 0x815e817a, 0xe2fb0fbc, 0x62e462a6, 0xd5c47131,
    0x36f1365a, 0xea6cd81b, 0x2ef72e72, 0xe05cb817, 0x7ae27a8e, 0xdff4113d,
    0xfec3fefb, 0xbc050a7f, 0x456f45cf, 0xb18aedde, 0x9c279c5d, 0x69c17b4e,
    0x7563759f, 0xa5ea2dc6, 0x915a914a, 0xeedb4fb4, 0x0c030c14, 0x05183006,
    0x0f810f11, 0x7a1e3cfb, 0xe7bbe7d0, 0x34376e8f, 0xf6c1f6e3, 0xba152a7b,
    0x1405143c, 0x0f28500a, 0x639a63a5, 0x57c675cd, 0x1d791d27, 0x8b3a74f2,
    0x0b800b1d, 0x79162cf9, 0x8ba08b64, 0x19ef27b9, 0xb3aeb32c, 0x0b9fc7a5,
    0xf3bef3ec, 0x3b1f3e85, 0xb2d0b22f, 0x899dc359, 0x3b8c3b4d, 0x6d76ece1,
    0x08020818, 0x06102004, 0x4b904bdd, 0x4996d5d9, 0x10041030, 0x0c204008,
    0xa6d5a613, 0x86b59353, 0x32f03256, 0xe964c819, 0xb950b932, 0xf08befa0,
    0xa82aa801, 0x7ea9ab54, 0x92d8924f, 0x91dd4349, 0xf142f1ea, 0xc61b3684,
    0x56e956fa, 0xc2aca12b, 0xdd49dd9e, 0xdb438692, 0x21762163, 0x9a4284ec,
    0xbfadbf38, 0x0e87f7a3, 0x0401040c, 0x03081002, 0xbed3be3b, 0x8c85f35f,
    0xd6c9d683, 0xa255aa6b, 0xfd41fdfe, 0xc3030682, 0x779f7799, 0x58ee25c7,
    0xeac6eac7, 0xb32d5a75, 0x3af23a4e, 0xef74e81d, 0xc832c8a1, 0x5669d264,
    0x8fa18f68, 0x1ae737bb, 0x579757f9, 0x40aea5d7, 0x1efb1e22, 0xf43c780f,
    0xfac2faf7, 0xbf0d1a7d, 0x2b882b7d, 0x6156ace9, 0x581658e8, 0x3ab0992c,
    0xc54fc5b6, 0xd173e69e, 0x278b2769, 0x644e9cef, 0xac2bac0d, 0x7da1bb56,
    0xe3bae3dc, 0x373f7e8d, 0xed45edce, 0xcf23468a, 0x97a79740, 0x10d757b7,
    0xbbacbb34, 0x0d8fe7a1, 0x46ed46ca, 0xce8ce123, 0x057f050f, 0x810a14fe,
    0x401040c0, 0x3080f920, 0x31723153, 0x9662c4e4, 0xe547e5d6, 0xc933668e,
    0x378f3759, 0x686edce7, 0x2c0b2c74, 0x1d58b016, 0x9edb9e5b, 0x94c5734f,
    0x0afe0a1e, 0xfb142805, 0xb152b12a, 0xf69bcfa4, 0xb553b526, 0xf593dfa6,
    0x06fd060a, 0xfe0c1803, 0x6c1b6cb4, 0x2dd84936, 0x1f851f21, 0x763e7cf3,
    0xa3aaa31c, 0x07bf87ad, 0x2af62a7e, 0xe354a815, 0x701c7090, 0x24e03938,
    0xffbdfff8, 0x3e070e83, 0xbad2ba37, 0x8f8de35d, 0x07830709, 0x7c0e1cff,
    0x2409246c, 0x1b489012, 0x16f9163a, 0xf22c580b, 0xc6cdc6b3, 0xae75ea63,
    0x616661a3, 0xaac27dcc};

const DWORD tbsm7_128[512] = {
    0xe75d5d5d, 0x5d5d5d5d, 0x9bdedede, 0xdededede, 0x00000000, 0x00000000,
    0x20b7b7b7, 0xb7b7b7b7, 0x8cd3d3d3, 0xd3d3d3d3, 0xa7cacaca, 0xcacacaca,
    0x443c3c3c, 0x3c3c3c3c, 0x170d0d0d, 0x0d0d0d0d, 0xbcc3c3c3, 0xc3c3c3c3,
    0xf1f8f8f8, 0xf8f8f8f8, 0xa4cbcbcb, 0xcbcbcbcb, 0x6e8d8d8d, 0x8d8d8d8d,
    0x9a767676, 0x76767676, 0x62898989, 0x89898989, 0x07aaaaaa, 0xaaaaaaaa,
    0x36121212, 0x12121212, 0x61888888, 0x88888888, 0x66222222, 0x22222222,
    0xd14f4f4f, 0x4f4f4f4f, 0x94dbdbdb, 0xdbdbdbdb, 0xb76d6d6d, 0x6d6d6d6d,
    0xc9474747, 0x47474747, 0xd5e4e4e4, 0xe4e4e4e4, 0xd44c4c4c, 0x4c4c4c4c,
    0x88787878, 0x78787878, 0x579a9a9a, 0x9a9a9a9a, 0xdb494949, 0x49494949,
    0x4c939393, 0x93939393, 0xb5c4c4c4, 0xc4c4c4c4, 0xb9c0c0c0, 0xc0c0c0c0,
    0x73868686, 0x86868686, 0x35131313, 0x13131313, 0x02a9a9a9, 0xa9a9a9a9,
    0x60202020, 0x20202020, 0xf5535353, 0x53535353, 0x241c1c1c, 0x1c1c1c1c,
    0xd24e4e4e, 0x4e4e4e4e, 0xa8cfcfcf, 0xcfcfcfcf, 0x5f353535, 0x35353535,
    0x4b393939, 0x39393939, 0x25b4b4b4, 0xb4b4b4b4, 0x1aa1a1a1, 0xa1a1a1a1,
    0xfc545454, 0x54545454, 0xac646464, 0x64646464, 0x05030303, 0x03030303,
    0xb0c7c7c7, 0xc7c7c7c7, 0x76858585, 0x85858585, 0xe45c5c5c, 0x5c5c5c5c,
    0xed5b5b5b, 0x5b5b5b5b, 0xaecdcdcd, 0xcdcdcdcd, 0x91d8d8d8, 0xd8d8d8d8,
    0x96727272, 0x72727272, 0x43969696, 0x96969696, 0xc6424242, 0x42424242,
    0x31b8b8b8, 0xb8b8b8b8, 0xdae1e1e1, 0xe1e1e1e1, 0x1fa2a2a2, 0xa2a2a2a2,
    0xa0606060, 0x60606060, 0xc8efefef, 0xefefefef, 0x3ebdbdbd, 0xbdbdbdbd,
    0x06020202, 0x02020202, 0x08afafaf, 0xafafafaf, 0x6d8c8c8c, 0x8c8c8c8c,
    0x95737373, 0x73737373, 0x847c7c7c, 0x7c7c7c7c, 0x817f7f7f, 0x7f7f7f7f,
    0xe25e5e5e, 0x5e5e5e5e, 0xf2f9f9f9, 0xf9f9f9f9, 0xaf656565, 0x65656565,
    0xd3e6e6e6, 0xe6e6e6e6, 0xc4ebebeb, 0xebebebeb, 0x0eadadad, 0xadadadad,
    0xee5a5a5a, 0x5a5a5a5a, 0x16a5a5a5, 0xa5a5a5a5, 0x8b797979, 0x79797979,
    0x6b8e8e8e, 0x8e8e8e8e, 0x3f151515, 0x15151515, 0x50303030, 0x30303030,
    0xcdececec, 0xecececec, 0x15a4a4a4, 0xa4a4a4a4, 0xbfc2c2c2, 0xc2c2c2c2,
    0x423e3e3e, 0x3e3e3e3e, 0xd9e0e0e0, 0xe0e0e0e0, 0x9c747474, 0x74747474,
    0xf3515151, 0x51515151, 0xf4fbfbfb, 0xfbfbfbfb, 0x772d2d2d, 0x2d2d2d2d,
    0xb26e6e6e, 0x6e6e6e6e, 0x45949494, 0x94949494, 0xd74d4d4d, 0x4d4d4d4d,
    0xff555555, 0x55555555, 0x5c343434, 0x34343434, 0x0baeaeae, 0xaeaeaeae,
    0xf6525252, 0x52525252, 0x827e7e7e, 0x7e7e7e7e, 0x5e9d9d9d, 0x9d9d9d9d,
    0xde4a4a4a, 0x4a4a4a4a, 0xe0f7f7f7, 0xf7f7f7f7, 0x79808080, 0x80808080,
    0xe9f0f0f0, 0xf0f0f0f0, 0x89d0d0d0, 0xd0d0d0d0, 0x49909090, 0x90909090,
    0x10a7a7a7, 0xa7a7a7a7, 0xc1e8e8e8, 0xe8e8e8e8, 0x589f9f9f, 0x9f9f9f9f,
    0xf0505050, 0x50505050, 0x86d5d5d5, 0xd5d5d5d5, 0x8ad1d1d1, 0xd1d1d1d1,
    0x51989898, 0x98989898, 0xadcccccc, 0xcccccccc, 0x19a0a0a0, 0xa0a0a0a0,
    0x39171717, 0x17171717, 0xe5f4f4f4, 0xf4f4f4f4, 0x23b6b6b6, 0xb6b6b6b6,
    0xbac1c1c1, 0xc1c1c1c1, 0x78282828, 0x28282828, 0xe15f5f5f, 0x5f5f5f5f,
    0x6a262626, 0x26262626, 0x03010101, 0x01010101, 0x04ababab, 0xabababab,
    0x6f252525, 0x25252525, 0x48383838, 0x38383838, 0x7f828282, 0x82828282,
    0x877d7d7d, 0x7d7d7d7d, 0xd8484848, 0x48484848, 0xfdfcfcfc, 0xfcfcfcfc,
    0x2d1b1b1b, 0x1b1b1b1b, 0xabcecece, 0xcececece, 0x413f3f3f, 0x3f3f3f3f,
    0xbd6b6b6b, 0x6b6b6b6b, 0xdfe2e2e2, 0xe2e2e2e2, 0xa9676767, 0x67676767,
    0xaa666666, 0x66666666, 0xc5434343, 0x43434343, 0xeb595959, 0x59595959,
    0x2b191919, 0x19191919, 0x75848484, 0x84848484, 0x473d3d3d, 0x3d3d3d3d,
    0xe6f5f5f5, 0xf5f5f5f5, 0x712f2f2f, 0x2f2f2f2f, 0xa2c9c9c9, 0xc9c9c9c9,
    0x3dbcbcbc, 0xbcbcbcbc, 0x92d9d9d9, 0xd9d9d9d9, 0x46959595, 0x95959595,
    0x7b292929, 0x29292929, 0xc3414141, 0x41414141, 0x97dadada, 0xdadadada,
    0x2e1a1a1a, 0x1a1a1a1a, 0x29b0b0b0, 0xb0b0b0b0, 0xc2e9e9e9, 0xe9e9e9e9,
    0xbb696969, 0x69696969, 0x8fd2d2d2, 0xd2d2d2d2, 0x8d7b7b7b, 0x7b7b7b7b,
    0x80d7d7d7, 0xd7d7d7d7, 0x33111111, 0x11111111, 0x549b9b9b, 0x9b9b9b9b,
    0x55333333, 0x33333333, 0x678a8a8a, 0x8a8a8a8a, 0x65232323, 0x23232323,
    0x1b090909, 0x09090909, 0x85d4d4d4, 0xd4d4d4d4, 0x93717171, 0x71717171,
    0xcc444444, 0x44444444, 0xb8686868, 0x68686868, 0xb16f6f6f, 0x6f6f6f6f,
    0xeff2f2f2, 0xf2f2f2f2, 0x120e0e0e, 0x0e0e0e0e, 0x98dfdfdf, 0xdfdfdfdf,
    0x70878787, 0x87878787, 0x9ddcdcdc, 0xdcdcdcdc, 0x7c838383, 0x83838383,
    0x28181818, 0x18181818, 0xbe6a6a6a, 0x6a6a6a6a, 0xcbeeeeee, 0xeeeeeeee,
    0x52999999, 0x99999999, 0x7a818181, 0x81818181, 0xa6626262, 0x62626262,
    0x5a363636, 0x36363636, 0x722e2e2e, 0x2e2e2e2e, 0x8e7a7a7a, 0x7a7a7a7a,
    0xfbfefefe, 0xfefefefe, 0xcf454545, 0x45454545, 0x5d9c9c9c, 0x9c9c9c9c,
    0x9f757575, 0x75757575, 0x4a919191, 0x91919191, 0x140c0c0c, 0x0c0c0c0c,
    0x110f0f0f, 0x0f0f0f0f, 0xd0e7e7e7, 0xe7e7e7e7, 0xe3f6f6f6, 0xf6f6f6f6,
    0x3c141414, 0x14141414, 0xa5636363, 0x63636363, 0x271d1d1d, 0x1d1d1d1d,
    0x1d0b0b0b, 0x0b0b0b0b, 0x648b8b8b, 0x8b8b8b8b, 0x2cb3b3b3, 0xb3b3b3b3,
    0xecf3f3f3, 0xf3f3f3f3, 0x2fb2b2b2, 0xb2b2b2b2, 0x4d3b3b3b, 0x3b3b3b3b,
    0x18080808, 0x08080808, 0xdd4b4b4b, 0x4b4b4b4b, 0x30101010, 0x10101010,
    0x13a6a6a6, 0xa6a6a6a6, 0x56323232, 0x32323232, 0x32b9b9b9, 0xb9b9b9b9,
    0x01a8a8a8, 0xa8a8a8a8, 0x4f929292, 0x92929292, 0xeaf1f1f1, 0xf1f1f1f1,
    0xfa565656, 0x56565656, 0x9edddddd, 0xdddddddd, 0x63212121, 0x21212121,
    0x38bfbfbf, 0xbfbfbfbf, 0x0c040404, 0x04040404, 0x3bbebebe, 0xbebebebe,
    0x83d6d6d6, 0xd6d6d6d6, 0xfefdfdfd, 0xfdfdfdfd, 0x99777777, 0x77777777,
    0xc7eaeaea, 0xeaeaeaea, 0x4e3a3a3a, 0x3a3a3a3a, 0xa1c8c8c8, 0xc8c8c8c8,
    0x688f8f8f, 0x8f8f8f8f, 0xf9575757, 0x57575757, 0x221e1e1e, 0x1e1e1e1e,
    0xf7fafafa, 0xfafafafa, 0x7d2b2b2b, 0x2b2b2b2b, 0xe8585858, 0x58585858,
    0xb6c5c5c5, 0xc5c5c5c5, 0x69272727, 0x27272727, 0x0dacacac, 0xacacacac,
    0xdce3e3e3, 0xe3e3e3e3, 0xceededed, 0xedededed, 0x40979797, 0x97979797,
    0x34bbbbbb, 0xbbbbbbbb, 0xca464646, 0x46464646, 0x0f050505, 0x05050505,
    0xc0404040, 0x40404040, 0x53313131, 0x31313131, 0xd6e5e5e5, 0xe5e5e5e5,
    0x59373737, 0x37373737, 0x742c2c2c, 0x2c2c2c2c, 0x5b9e9e9e, 0x9e9e9e9e,
    0x1e0a0a0a, 0x0a0a0a0a, 0x2ab1b1b1, 0xb1b1b1b1, 0x26b5b5b5, 0xb5b5b5b5,
    0x0a060606, 0x06060606, 0xb46c6c6c, 0x6c6c6c6c, 0x211f1f1f, 0x1f1f1f1f,
    0x1ca3a3a3, 0xa3a3a3a3, 0x7e2a2a2a, 0x2a2a2a2a, 0x90707070, 0x70707070,
    0xf8ffffff, 0xffffffff, 0x37bababa, 0xbabababa, 0x09070707, 0x07070707,
    0x6c242424, 0x24242424, 0x3a161616, 0x16161616, 0xb3c6c6c6, 0xc6c6c6c6,
    0xa3616161, 0x61616161};

const DWORD tbs0_128[256] = {
    0x5d000000, 0xde000000, 0x00000000, 0xb7000000, 0xd3000000, 0xca000000,
    0x3c000000, 0x0d000000, 0xc3000000, 0xf8000000, 0xcb000000, 0x8d000000,
    0x76000000, 0x89000000, 0xaa000000, 0x12000000, 0x88000000, 0x22000000,
    0x4f000000, 0xdb000000, 0x6d000000, 0x47000000, 0xe4000000, 0x4c000000,
    0x78000000, 0x9a000000, 0x49000000, 0x93000000, 0xc4000000, 0xc0000000,
    0x86000000, 0x13000000, 0xa9000000, 0x20000000, 0x53000000, 0x1c000000,
    0x4e000000, 0xcf000000, 0x35000000, 0x39000000, 0xb4000000, 0xa1000000,
    0x54000000, 0x64000000, 0x03000000, 0xc7000000, 0x85000000, 0x5c000000,
    0x5b000000, 0xcd000000, 0xd8000000, 0x72000000, 0x96000000, 0x42000000,
    0xb8000000, 0xe1000000, 0xa2000000, 0x60000000, 0xef000000, 0xbd000000,
    0x02000000, 0xaf000000, 0x8c000000, 0x73000000, 0x7c000000, 0x7f000000,
    0x5e000000, 0xf9000000, 0x65000000, 0xe6000000, 0xeb000000, 0xad000000,
    0x5a000000, 0xa5000000, 0x79000000, 0x8e000000, 0x15000000, 0x30000000,
    0xec000000, 0xa4000000, 0xc2000000, 0x3e000000, 0xe0000000, 0x74000000,
    0x51000000, 0xfb000000, 0x2d000000, 0x6e000000, 0x94000000, 0x4d000000,
    0x55000000, 0x34000000, 0xae000000, 0x52000000, 0x7e000000, 0x9d000000,
    0x4a000000, 0xf7000000, 0x80000000, 0xf0000000, 0xd0000000, 0x90000000,
    0xa7000000, 0xe8000000, 0x9f000000, 0x50000000, 0xd5000000, 0xd1000000,
    0x98000000, 0xcc000000, 0xa0000000, 0x17000000, 0xf4000000, 0xb6000000,
    0xc1000000, 0x28000000, 0x5f000000, 0x26000000, 0x01000000, 0xab000000,
    0x25000000, 0x38000000, 0x82000000, 0x7d000000, 0x48000000, 0xfc000000,
    0x1b000000, 0xce000000, 0x3f000000, 0x6b000000, 0xe2000000, 0x67000000,
    0x66000000, 0x43000000, 0x59000000, 0x19000000, 0x84000000, 0x3d000000,
    0xf5000000, 0x2f000000, 0xc9000000, 0xbc000000, 0xd9000000, 0x95000000,
    0x29000000, 0x41000000, 0xda000000, 0x1a000000, 0xb0000000, 0xe9000000,
    0x69000000, 0xd2000000, 0x7b000000, 0xd7000000, 0x11000000, 0x9b000000,
    0x33000000, 0x8a000000, 0x23000000, 0x09000000, 0xd4000000, 0x71000000,
    0x44000000, 0x68000000, 0x6f000000, 0xf2000000, 0x0e000000, 0xdf000000,
    0x87000000, 0xdc000000, 0x83000000, 0x18000000, 0x6a000000, 0xee000000,
    0x99000000, 0x81000000, 0x62000000, 0x36000000, 0x2e000000, 0x7a000000,
    0xfe000000, 0x45000000, 0x9c000000, 0x75000000, 0x91000000, 0x0c000000,
    0x0f000000, 0xe7000000, 0xf6000000, 0x14000000, 0x63000000, 0x1d000000,
    0x0b000000, 0x8b000000, 0xb3000000, 0xf3000000, 0xb2000000, 0x3b000000,
    0x08000000, 0x4b000000, 0x10000000, 0xa6000000, 0x32000000, 0xb9000000,
    0xa8000000, 0x92000000, 0xf1000000, 0x56000000, 0xdd000000, 0x21000000,
    0xbf000000, 0x04000000, 0xbe000000, 0xd6000000, 0xfd000000, 0x77000000,
    0xea000000, 0x3a000000, 0xc8000000, 0x8f000000, 0x57000000, 0x1e000000,
    0xfa000000, 0x2b000000, 0x58000000, 0xc5000000, 0x27000000, 0xac000000,
    0xe3000000, 0xed000000, 0x97000000, 0xbb000000, 0x46000000, 0x05000000,
    0x40000000, 0x31000000, 0xe5000000, 0x37000000, 0x2c000000, 0x9e000000,
    0x0a000000, 0xb1000000, 0xb5000000, 0x06000000, 0x6c000000, 0x1f000000,
    0xa3000000, 0x2a000000, 0x70000000, 0xff000000, 0xba000000, 0x07000000,
    0x24000000, 0x16000000, 0xc6000000, 0x61000000};

const DWORD tbs1_128[256] = {
    0x005d0000, 0x00de0000, 0x00000000, 0x00b70000, 0x00d30000, 0x00ca0000,
    0x003c0000, 0x000d0000, 0x00c30000, 0x00f80000, 0x00cb0000, 0x008d0000,
    0x00760000, 0x00890000, 0x00aa0000, 0x00120000, 0x00880000, 0x00220000,
    0x004f0000, 0x00db0000, 0x006d0000, 0x00470000, 0x00e40000, 0x004c0000,
    0x00780000, 0x009a0000, 0x00490000, 0x00930000, 0x00c40000, 0x00c00000,
    0x00860000, 0x00130000, 0x00a90000, 0x00200000, 0x00530000, 0x001c0000,
    0x004e0000, 0x00cf0000, 0x00350000, 0x00390000, 0x00b40000, 0x00a10000,
    0x00540000, 0x00640000, 0x00030000, 0x00c70000, 0x00850000, 0x005c0000,
    0x005b0000, 0x00cd0000, 0x00d80000, 0x00720000, 0x00960000, 0x00420000,
    0x00b80000, 0x00e10000, 0x00a20000, 0x00600000, 0x00ef0000, 0x00bd0000,
    0x00020000, 0x00af0000, 0x008c0000, 0x00730000, 0x007c0000, 0x007f0000,
    0x005e0000, 0x00f90000, 0x00650000, 0x00e60000, 0x00eb0000, 0x00ad0000,
    0x005a0000, 0x00a50000, 0x00790000, 0x008e0000, 0x00150000, 0x00300000,
    0x00ec0000, 0x00a40000, 0x00c20000, 0x003e0000, 0x00e00000, 0x00740000,
    0x00510000, 0x00fb0000, 0x002d0000, 0x006e0000, 0x00940000, 0x004d0000,
    0x00550000, 0x00340000, 0x00ae0000, 0x00520000, 0x007e0000, 0x009d0000,
    0x004a0000, 0x00f70000, 0x00800000, 0x00f00000, 0x00d00000, 0x00900000,
    0x00a70000, 0x00e80000, 0x009f0000, 0x00500000, 0x00d50000, 0x00d10000,
    0x00980000, 0x00cc0000, 0x00a00000, 0x00170000, 0x00f40000, 0x00b60000,
    0x00c10000, 0x00280000, 0x005f0000, 0x00260000, 0x00010000, 0x00ab0000,
    0x00250000, 0x00380000, 0x00820000, 0x007d0000, 0x00480000, 0x00fc0000,
    0x001b0000, 0x00ce0000, 0x003f0000, 0x006b0000, 0x00e20000, 0x00670000,
    0x00660000, 0x00430000, 0x00590000, 0x00190000, 0x00840000, 0x003d0000,
    0x00f50000, 0x002f0000, 0x00c90000, 0x00bc0000, 0x00d90000, 0x00950000,
    0x00290000, 0x00410000, 0x00da0000, 0x001a0000, 0x00b00000, 0x00e90000,
    0x00690000, 0x00d20000, 0x007b0000, 0x00d70000, 0x00110000, 0x009b0000,
    0x00330000, 0x008a0000, 0x00230000, 0x00090000, 0x00d40000, 0x00710000,
    0x00440000, 0x00680000, 0x006f0000, 0x00f20000, 0x000e0000, 0x00df0000,
    0x00870000, 0x00dc0000, 0x00830000, 0x00180000, 0x006a0000, 0x00ee0000,
    0x00990000, 0x00810000, 0x00620000, 0x00360000, 0x002e0000, 0x007a0000,
    0x00fe0000, 0x00450000, 0x009c0000, 0x00750000, 0x00910000, 0x000c0000,
    0x000f0000, 0x00e70000, 0x00f60000, 0x00140000, 0x00630000, 0x001d0000,
    0x000b0000, 0x008b0000, 0x00b30000, 0x00f30000, 0x00b20000, 0x003b0000,
    0x00080000, 0x004b0000, 0x00100000, 0x00a60000, 0x00320000, 0x00b90000,
    0x00a80000, 0x00920000, 0x00f10000, 0x00560000, 0x00dd0000, 0x00210000,
    0x00bf0000, 0x00040000, 0x00be0000, 0x00d60000, 0x00fd0000, 0x00770000,
    0x00ea0000, 0x003a0000, 0x00c80000, 0x008f0000, 0x00570000, 0x001e0000,
    0x00fa0000, 0x002b0000, 0x00580000, 0x00c50000, 0x00270000, 0x00ac0000,
    0x00e30000, 0x00ed0000, 0x00970000, 0x00bb0000, 0x00460000, 0x00050000,
    0x00400000, 0x00310000, 0x00e50000, 0x00370000, 0x002c0000, 0x009e0000,
    0x000a0000, 0x00b10000, 0x00b50000, 0x00060000, 0x006c0000, 0x001f0000,
    0x00a30000, 0x002a0000, 0x00700000, 0x00ff0000, 0x00ba0000, 0x00070000,
    0x00240000, 0x00160000, 0x00c60000, 0x00610000};

const WORD tbs2_128[256] = {
    0x5d00, 0xde00, 0x0000, 0xb700, 0xd300, 0xca00, 0x3c00, 0x0d00, 0xc300,
    0xf800, 0xcb00, 0x8d00, 0x7600, 0x8900, 0xaa00, 0x1200, 0x8800, 0x2200,
    0x4f00, 0xdb00, 0x6d00, 0x4700, 0xe400, 0x4c00, 0x7800, 0x9a00, 0x4900,
    0x9300, 0xc400, 0xc000, 0x8600, 0x1300, 0xa900, 0x2000, 0x5300, 0x1c00,
    0x4e00, 0xcf00, 0x3500, 0x3900, 0xb400, 0xa100, 0x5400, 0x6400, 0x0300,
    0xc700, 0x8500, 0x5c00, 0x5b00, 0xcd00, 0xd800, 0x7200, 0x9600, 0x4200,
    0xb800, 0xe100, 0xa200, 0x6000, 0xef00, 0xbd00, 0x0200, 0xaf00, 0x8c00,
    0x7300, 0x7c00, 0x7f00, 0x5e00, 0xf900, 0x6500, 0xe600, 0xeb00, 0xad00,
    0x5a00, 0xa500, 0x7900, 0x8e00, 0x1500, 0x3000, 0xec00, 0xa400, 0xc200,
    0x3e00, 0xe000, 0x7400, 0x5100, 0xfb00, 0x2d00, 0x6e00, 0x9400, 0x4d00,
    0x5500, 0x3400, 0xae00, 0x5200, 0x7e00, 0x9d00, 0x4a00, 0xf700, 0x8000,
    0xf000, 0xd000, 0x9000, 0xa700, 0xe800, 0x9f00, 0x5000, 0xd500, 0xd100,
    0x9800, 0xcc00, 0xa000, 0x1700, 0xf400, 0xb600, 0xc100, 0x2800, 0x5f00,
    0x2600, 0x0100, 0xab00, 0x2500, 0x3800, 0x8200, 0x7d00, 0x4800, 0xfc00,
    0x1b00, 0xce00, 0x3f00, 0x6b00, 0xe200, 0x6700, 0x6600, 0x4300, 0x5900,
    0x1900, 0x8400, 0x3d00, 0xf500, 0x2f00, 0xc900, 0xbc00, 0xd900, 0x9500,
    0x2900, 0x4100, 0xda00, 0x1a00, 0xb000, 0xe900, 0x6900, 0xd200, 0x7b00,
    0xd700, 0x1100, 0x9b00, 0x3300, 0x8a00, 0x2300, 0x0900, 0xd400, 0x7100,
    0x4400, 0x6800, 0x6f00, 0xf200, 0x0e00, 0xdf00, 0x8700, 0xdc00, 0x8300,
    0x1800, 0x6a00, 0xee00, 0x9900, 0x8100, 0x6200, 0x3600, 0x2e00, 0x7a00,
    0xfe00, 0x4500, 0x9c00, 0x7500, 0x9100, 0x0c00, 0x0f00, 0xe700, 0xf600,
    0x1400, 0x6300, 0x1d00, 0x0b00, 0x8b00, 0xb300, 0xf300, 0xb200, 0x3b00,
    0x0800, 0x4b00, 0x1000, 0xa600, 0x3200, 0xb900, 0xa800, 0x9200, 0xf100,
    0x5600, 0xdd00, 0x2100, 0xbf00, 0x0400, 0xbe00, 0xd600, 0xfd00, 0x7700,
    0xea00, 0x3a00, 0xc800, 0x8f00, 0x5700, 0x1e00, 0xfa00, 0x2b00, 0x5800,
    0xc500, 0x2700, 0xac00, 0xe300, 0xed00, 0x9700, 0xbb00, 0x4600, 0x0500,
    0x4000, 0x3100, 0xe500, 0x3700, 0x2c00, 0x9e00, 0x0a00, 0xb100, 0xb500,
    0x0600, 0x6c00, 0x1f00, 0xa300, 0x2a00, 0x7000, 0xff00, 0xba00, 0x0700,
    0x2400, 0x1600, 0xc600, 0x6100};

const BYTE tbs3_128[256] = {
    0x5d, 0xde, 0x00, 0xb7, 0xd3, 0xca, 0x3c, 0x0d, 0xc3, 0xf8, 0xcb, 0x8d,
    0x76, 0x89, 0xaa, 0x12, 0x88, 0x22, 0x4f, 0xdb, 0x6d, 0x47, 0xe4, 0x4c,
    0x78, 0x9a, 0x49, 0x93, 0xc4, 0xc0, 0x86, 0x13, 0xa9, 0x20, 0x53, 0x1c,
    0x4e, 0xcf, 0x35, 0x39, 0xb4, 0xa1, 0x54, 0x64, 0x03, 0xc7, 0x85, 0x5c,
    0x5b, 0xcd, 0xd8, 0x72, 0x96, 0x42, 0xb8, 0xe1, 0xa2, 0x60, 0xef, 0xbd,
    0x02, 0xaf, 0x8c, 0x73, 0x7c, 0x7f, 0x5e, 0xf9, 0x65, 0xe6, 0xeb, 0xad,
    0x5a, 0xa5, 0x79, 0x8e, 0x15, 0x30, 0xec, 0xa4, 0xc2, 0x3e, 0xe0, 0x74,
    0x51, 0xfb, 0x2d, 0x6e, 0x94, 0x4d, 0x55, 0x34, 0xae, 0x52, 0x7e, 0x9d,
    0x4a, 0xf7, 0x80, 0xf0, 0xd0, 0x90, 0xa7, 0xe8, 0x9f, 0x50, 0xd5, 0xd1,
    0x98, 0xcc, 0xa0, 0x17, 0xf4, 0xb6, 0xc1, 0x28, 0x5f, 0x26, 0x01, 0xab,
    0x25, 0x38, 0x82, 0x7d, 0x48, 0xfc, 0x1b, 0xce, 0x3f, 0x6b, 0xe2, 0x67,
    0x66, 0x43, 0x59, 0x19, 0x84, 0x3d, 0xf5, 0x2f, 0xc9, 0xbc, 0xd9, 0x95,
    0x29, 0x41, 0xda, 0x1a, 0xb0, 0xe9, 0x69, 0xd2, 0x7b, 0xd7, 0x11, 0x9b,
    0x33, 0x8a, 0x23, 0x09, 0xd4, 0x71, 0x44, 0x68, 0x6f, 0xf2, 0x0e, 0xdf,
    0x87, 0xdc, 0x83, 0x18, 0x6a, 0xee, 0x99, 0x81, 0x62, 0x36, 0x2e, 0x7a,
    0xfe, 0x45, 0x9c, 0x75, 0x91, 0x0c, 0x0f, 0xe7, 0xf6, 0x14, 0x63, 0x1d,
    0x0b, 0x8b, 0xb3, 0xf3, 0xb2, 0x3b, 0x08, 0x4b, 0x10, 0xa6, 0x32, 0xb9,
    0xa8, 0x92, 0xf1, 0x56, 0xdd, 0x21, 0xbf, 0x04, 0xbe, 0xd6, 0xfd, 0x77,
    0xea, 0x3a, 0xc8, 0x8f, 0x57, 0x1e, 0xfa, 0x2b, 0x58, 0xc5, 0x27, 0xac,
    0xe3, 0xed, 0x97, 0xbb, 0x46, 0x05, 0x40, 0x31, 0xe5, 0x37, 0x2c, 0x9e,
    0x0a, 0xb1, 0xb5, 0x06, 0x6c, 0x1f, 0xa3, 0x2a, 0x70, 0xff, 0xba, 0x07,
    0x24, 0x16, 0xc6, 0x61};

///////////////////////////////////////////////////////////

#ifndef USE_NXT128
#error Set USE_NXT128 in nxt_common.h to use NXT128
#endif

#if ((NXT128_TOTAL_ROUNDS <= 1) || (NXT128_TOTAL_ROUNDS > 255))
#error NXT128_TOTAL_ROUNDS must be greater than 1 and smaller than 256
#elif ((defined NXT128_UNROLL_LOOPS) && (NXT128_TOTAL_ROUNDS != 16) \
       && (NXT128_TOTAL_ROUNDS != 12))
#error NXT128_TOTAL_ROUNDS must be 12 or 16 when NXT128_UNROLL_LOOPS is set
#endif

#define SIGMA_MU8_0(x, y)                 \
      tbsm0_128[((x & 0xff000000) >> 23)] \
    ^ tbsm1_128[((x & 0x00ff0000) >> 15)] \
    ^ tbsm2_128[((x & 0x0000ff00) >>  7)] \
    ^ tbsm3_128[((x & 0x000000ff) <<  1)] \
    ^ tbsm4_128[((y & 0xff000000) >> 23)] \
    ^ tbsm5_128[((y & 0x00ff0000) >> 15)] \
    ^ tbsm6_128[((y & 0x0000ff00) >>  7)] \
    ^ tbsm7_128[((y & 0x000000ff) <<  1)]

#define SIGMA_MU8_1(x, y)                     \
      tbsm0_128[((x & 0xff000000) >> 23) + 1] \
    ^ tbsm1_128[((x & 0x00ff0000) >> 15) + 1] \
    ^ tbsm2_128[((x & 0x0000ff00) >>  7) + 1] \
    ^ tbsm3_128[((x & 0x000000ff) <<  1) + 1] \
    ^ tbsm4_128[((y & 0xff000000) >> 23) + 1] \
    ^ tbsm5_128[((y & 0x00ff0000) >> 15) + 1] \
    ^ tbsm6_128[((y & 0x0000ff00) >>  7) + 1] \
    ^ tbsm7_128[((y & 0x000000ff) <<  1) + 1]

#define SIGMA(x)                       \
      tbs0_128[(x & 0xff000000) >> 24] \
    ^ tbs1_128[(x & 0x00ff0000) >> 16] \
    ^ tbs2_128[(x & 0x0000ff00) >>  8] \
    ^ tbs3_128[(x & 0x000000ff)      ]

#define F64(i)                              \
{                                           \
    tmp0 = x0 ^ x1 ^ rk[0];                 \
    tmp1 = x2 ^ x3 ^ rk[1];                 \
                                            \
    smu0 = rk[2] ^ SIGMA_MU8_0(tmp0, tmp1); \
    smu1 = rk[3] ^ SIGMA_MU8_1(tmp0, tmp1); \
                                            \
    f0 = rk[0] ^ SIGMA(smu0);               \
    f1 = rk[1] ^ SIGMA(smu1);               \
}

#define ELMOR128(i)    \
{                      \
    F64(i);            \
                       \
    tmp0 = x0 ^ f0;    \
    x0 = NXT_OR(tmp0); \
    x1 ^= f0;          \
                       \
    tmp1 = x2 ^ f1;    \
    x2 = NXT_OR(tmp1); \
    x3 ^= f1;          \
    rk += 4;           \
}

#define ELMIO128(i)    \
{                      \
    F64(i);            \
                       \
    tmp0 = x0 ^ f0;    \
    x0 = NXT_IO(tmp0); \
    x1 ^= f0;          \
                       \
    tmp1 = x2 ^ f1;    \
    x2 = NXT_IO(tmp1); \
    x3 ^= f1;          \
    rk -= 4;           \
}

#define ELMID128(i) \
{                   \
    F64(i);         \
                    \
    x0 ^= f0;       \
    x1 ^= f0;       \
                    \
    x2 ^= f1;       \
    x3 ^= f1;       \
}

void Ideanxt128_encrypt(const nxt128_ctx *ctx,const BYTE *in,BYTE *out)
{
    DWORD x0, x1, x2, x3;
    DWORD tmp0, tmp1;
    DWORD f0, f1;
    DWORD smu0, smu1;
    DWORD *rk;

#ifndef NXT128_UNROLL_LOOPS
    int i;
#endif

    PACK32(in     , &x0);
    PACK32(in +  4, &x1);
    PACK32(in +  8, &x2);
    PACK32(in + 12, &x3);

    rk = (DWORD *) ctx->rk;

#ifdef NXT128_UNROLL_LOOPS
#if NXT128_TOTAL_ROUNDS == 16
    ELMOR128( 0); ELMOR128( 4); ELMOR128( 8); ELMOR128(12); ELMOR128(16);
    ELMOR128(20); ELMOR128(24); ELMOR128(28); ELMOR128(32); ELMOR128(36);
    ELMOR128(40); ELMOR128(44); ELMOR128(48); ELMOR128(52); ELMOR128(56);
    ELMID128(60);
#elif NXT128_TOTAL_ROUNDS == 12
    ELMOR128( 0); ELMOR128( 4); ELMOR128( 8); ELMOR128(12); ELMOR128(16);
    ELMOR128(20); ELMOR128(24); ELMOR128(28); ELMOR128(32); ELMOR128(36);
    ELMOR128(40);
    ELMID128(44);
#endif
#else /* !NXT128_UNROLL_LOOPS */
    for (i = 0; i < (NXT128_TOTAL_ROUNDS - 1); i++) {
        ELMOR128(0);
    }
    ELMID128(0);
#endif /* !NXT128_UNROLL_LOOPS */

    UNPACK32(x0, out     );
    UNPACK32(x1, out +  4);
    UNPACK32(x2, out +  8);
    UNPACK32(x3, out + 12);
}

void Ideanxt128_decrypt(const nxt128_ctx *ctx,const BYTE *in,BYTE *out)
{
    DWORD x0, x1, x2, x3;
    DWORD tmp0, tmp1;
    DWORD f0, f1;
    DWORD smu0, smu1;
    DWORD *rk;

#ifndef NXT128_UNROLL_LOOPS
    int i;
#endif

    PACK32(in     , &x0);
    PACK32(in +  4, &x1);
    PACK32(in +  8, &x2);
    PACK32(in + 12, &x3);

    rk = ((DWORD *) ctx->rk) + 4 * (NXT128_TOTAL_ROUNDS - 1);

#ifdef NXT128_UNROLL_LOOPS
#if NXT128_TOTAL_ROUNDS == 16
    ELMIO128(60); ELMIO128(56); ELMIO128(52); ELMIO128(48); ELMIO128(44);
    ELMIO128(40); ELMIO128(36); ELMIO128(32); ELMIO128(28); ELMIO128(24);
    ELMIO128(20); ELMIO128(16); ELMIO128(12); ELMIO128( 8); ELMIO128( 4);
    ELMID128(0);
#elif NXT128_TOTAL_ROUNDS == 12
    ELMIO128(44); ELMIO128(40); ELMIO128(36); ELMIO128(32); ELMIO128(28);
    ELMIO128(24); ELMIO128(20); ELMIO128(16); ELMIO128(12); ELMIO128( 8);
    ELMIO128( 4);
    ELMID128(0);
#endif
#else /* !NXT128_UNROLL_LOOPS */
    for (i = 0; i < (NXT128_TOTAL_ROUNDS - 1); i++) {
        ELMIO128(0);
    }
    ELMID128(0);
#endif /* !NXT128_UNROLL_LOOPS */

    UNPACK32(x0, out     );
    UNPACK32(x1, out +  4);
    UNPACK32(x2, out +  8);
    UNPACK32(x3, out + 12);
}

#define MIX128(x, y)                           \
{                                              \
    *(y    ) = *(x + 2) ^ *(x + 4) ^ *(x + 6); \
    *(y + 1) = *(x + 3) ^ *(x + 5) ^ *(x + 7); \
    *(y + 2) = *(x    ) ^ *(x + 4) ^ *(x + 6); \
    *(y + 3) = *(x + 1) ^ *(x + 5) ^ *(x + 7); \
    *(y + 4) = *(x    ) ^ *(x + 2) ^ *(x + 6); \
    *(y + 5) = *(x + 1) ^ *(x + 3) ^ *(x + 7); \
    *(y + 6) = *(x    ) ^ *(x + 2) ^ *(x + 4); \
    *(y + 7) = *(x + 1) ^ *(x + 3) ^ *(x + 5); \
}

void nxt128_dnl128(const BYTE *mkey,DWORD *reg,DWORD *rkey,BYTE eq)
{
    DWORD t0[8];
    DWORD t1[8];
    DWORD dkey32[8];
    DWORD x0, x1, x2, x3;
    DWORD tmp0, tmp1;
    DWORD smu0, smu1;
    DWORD f0, f1;
    DWORD *rk;
    DWORD lfsr_value;
    BYTE dkey[32];
    int i;

    /* D-part */
    for (i = 0; i < 10; i++) {
        LFSR(reg, lfsr_value);
        dkey[0 + i * 3] = mkey[0 + i * 3] ^ ((BYTE) (lfsr_value >> 16));
        dkey[1 + i * 3] = mkey[1 + i * 3] ^ ((BYTE) (lfsr_value >> 8));
        dkey[2 + i * 3] = mkey[2 + i * 3] ^ ((BYTE) (lfsr_value));
    }

    LFSR(reg, lfsr_value);
    dkey[30] = mkey[30] ^ ((BYTE) (lfsr_value >> 16));
    dkey[31] = mkey[31] ^ ((BYTE) (lfsr_value >> 8));

    /* NL128-part */
    rk = dkey32;

    PACK32(dkey     , dkey32    );
    PACK32(dkey +  4, dkey32 + 1);
    PACK32(dkey +  8, dkey32 + 2);
    PACK32(dkey + 12, dkey32 + 3);
    PACK32(dkey + 16, dkey32 + 4);
    PACK32(dkey + 20, dkey32 + 5);
    PACK32(dkey + 24, dkey32 + 6);
    PACK32(dkey + 28, dkey32 + 7);

    t1[0] = SIGMA_MU8_0(dkey32[0], dkey32[1]);
    t1[1] = SIGMA_MU8_1(dkey32[0], dkey32[1]);
    t1[2] = SIGMA_MU8_0(dkey32[2], dkey32[3]);
    t1[3] = SIGMA_MU8_1(dkey32[2], dkey32[3]);
    t1[4] = SIGMA_MU8_0(dkey32[4], dkey32[5]);
    t1[5] = SIGMA_MU8_1(dkey32[4], dkey32[5]);
    t1[6] = SIGMA_MU8_0(dkey32[6], dkey32[7]);
    t1[7] = SIGMA_MU8_1(dkey32[6], dkey32[7]);

    MIX128(t1, t0);

    PACK32(pad     , t1    );
    PACK32(pad +  4, t1 + 1);
    PACK32(pad +  8, t1 + 2);
    PACK32(pad + 12, t1 + 3);
    PACK32(pad + 16, t1 + 4);
    PACK32(pad + 20, t1 + 5);
    PACK32(pad + 24, t1 + 6);
    PACK32(pad + 28, t1 + 7);

    t0[0] ^= t1[0];
    t0[1] ^= t1[1];
    t0[2] ^= t1[2];
    t0[3] ^= t1[3];
    t0[4] ^= t1[4];
    t0[5] ^= t1[5];
    t0[6] ^= t1[6];
    t0[7] ^= t1[7];

    if (eq) {
        t0[0] = ~t0[0];
        t0[1] = ~t0[1];
        t0[2] = ~t0[2];
        t0[3] = ~t0[3];
        t0[4] = ~t0[4];
        t0[5] = ~t0[5];
        t0[6] = ~t0[6];
        t0[7] = ~t0[7];
    }

    x0 = SIGMA(t0[0]) ^ SIGMA(t0[4]);
    x1 = SIGMA(t0[1]) ^ SIGMA(t0[5]);
    x2 = SIGMA(t0[2]) ^ SIGMA(t0[6]);
    x3 = SIGMA(t0[3]) ^ SIGMA(t0[7]);

    ELMOR128(0);
    ELMID128(0);

    rkey[0] = x0;
    rkey[1] = x1;
    rkey[2] = x2;
    rkey[3] = x3;
}

void Ideanxt128_set_key(nxt128_ctx *ctx,const BYTE *key,const WORD key_len)
{
    const WORD ek = 256;
    BYTE pk[32];
    BYTE mk[32];
    DWORD reg;
    int i;
    BYTE eq;

    //assert((key_len % 8 == 0) && (key_len <= 256));

    /* Initialization and LFSR Pre-clocking */
    reg = 0x006a0000 | ((NXT128_TOTAL_ROUNDS << 8) & 0x0000ff00)
          | ((~NXT128_TOTAL_ROUNDS) & 0x000000ff);
    if (reg & 0x1) {
        reg ^= 0x100001b;
    }
    reg >>= 1;

    eq = (key_len == ek);

    if (key_len < ek) {
        nxt_p(key, (key_len >> 3), pk, ek);
        nxt_m(pk, mk, ek);

        for (i = 0; i < NXT128_TOTAL_ROUNDS; i++) {
            nxt128_dnl128(mk, &reg, &ctx->rk[i * 4], eq);
        }
    } else {
        for (i = 0; i < NXT128_TOTAL_ROUNDS; i++) {
            nxt128_dnl128(key, &reg, &ctx->rk[i * 4], eq);
        }
    }
}
